<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\Account;
use App\Models\Transaction;
use App\Service\ActivityService;
use App\Service\SequenceService;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\AccountsImport;
use DB;

class AccountController extends Controller
{
    public function createAccounts(Request $request){
          // Validate Item
          $validator=validator($request->all(),[
            'account_type'=>'required',
            'account_name'=>'required',
            'account_code'=>'required'
        ]);

        //Inout 1 = payment rec , 2= payment made

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['account_type']=$request['account_type'];    // Account Group 
            $obj['account_posting']=$request['account_posting'];   // Balance sheet or Profit & Loss from the masters
            $obj['account_posting_id']=$request['account_posting_id'];   // Balance sheet or Profit & Loss from the masters
            $obj['account_name']=$request['account_name'];
            $obj['account_code']=$request['account_code'];
            $obj['parent_name']=$request['parent_name'];
            $obj['description']=$request['description'];
            $obj['upload_image']=$request['upload_image'];
            $obj['tax_code']=$request['tax_code'];
        
            $obj['custome_feilds']=$request['custome_feilds'];
            $obj['sub_account']=$request['sub_account'];
            $obj['parent_id']=$request['parent_id'];

            // Bank details
            $obj['owner_name']=$request['owner_name'];
            $obj['account_no']=$request['account_no'];
            $obj['bank_account_type']=$request['bank_account_type'];   //Current , Saving , Salary From the masters
            $obj['bank_branch']=$request['bank_branch'];
            $obj['ifsc']=$request['ifsc'];
            $obj['currency']=$request['currency'];
            $obj['lock_status']=0;

            // Opening Balance
            $obj['opening_balance']=$request['opening_balance']??0;
            $obj['as_on_date']=$request['as_on_date'];

            if($request['id']>0){    
                //Calling for update
                try{

                    // update account information
                    $accounts = Account::findOrFail($request['id']);
                    $accounts->update($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Accounts',$accounts['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else{

                //  upload_image field is an array 
                if(isset($request['upload_image']) && is_array($request['upload_image'])) {
                    $uploadImages = json_encode($request['upload_image']);
                    $obj['upload_image'] = $uploadImages;
                }

                // Account Created
                $accounts=Account::create($obj);

                $module='accounts';
                // Update Sequence Number
                $sequence=new SequenceService;
                $sequence->updateSequence($module);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Accounts',$accounts['id'],'Created');

            }  
        }
        $response=[
            'success'=>true,
            'data'=>$accounts,
            'message'=>$request['id']>0?'Account Updated Successfully':"Account Added Successfully",
        ];

        return response()->json($response);
    }

    public function getAccounts(Request $request){
        $user=Auth::user();

        $accounts = Account::where('status', 1)
            ->where('is_disabled', 0)
            ->where('sub_account', 0)
            // ->where(function ($query) use ($user) {
            //     $query->where('organisation_id',null)
            //         ->orWhere('organisation_id', $user['active_organisation']);
            // })
            ->with('sub_accounts');

        if($request['account_type']!=null && isset($request['account_type'])){
            $accounts=$accounts->where('account_type',$request['account_type']);
        }

        if($request['account_types']!=null && isset($request['account_types'])){
            $accounts=$accounts->whereIn('account_type',$request['account_types']);
        }
        
        if ($request['search'] != null && $request['search'] != '') {

            $searchTerm = $request['search'];
            $accounts = $accounts->where(function ($query) use ($searchTerm) {
                $query->where('account_type', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('account_name', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('account_code', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('ifsc', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('account_no', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('account_posting', 'LIKE', '%' . $searchTerm . '%');
            });
        }
    
        $count=$accounts->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $accounts = $accounts->orderby($request['sort_by'],$sort_order);

        }else{
            $accounts = $accounts->orderby('id','desc');
        }
        
        $accounts=$accounts->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'total_accounts'=>$count,
            'accounts'=>$accounts,
            'message'=>'All Accounts Listed Successfully'
        ];
        
        return response()->json($response);

    }             
    
    public function details(Request $request){
        $user=Auth::user();
        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required',
            'fy'=>'required'
        ]);

        //Inout 1 = payment rec , 2= payment made

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $transactions=[];
            $total_amount=[];

            $accounts=Account::where('id',$request['id'])
                // ->where('organisation_id',$user['active_organisation'])
                ->with('activity','sub_accounts')
                ->first();
            
            if($accounts!=null){
                $transactions=Transaction::where('account_id',$request['id'])
                    // ->where('organisation_id',$user['active_organisation'])
                    ->with('invoice:id,invoice_id','credit_note:id,credit_note_id',
                        'bill:id,bill_no','debit_note:id,debit_note_id','journal:id,journal_no',
                        'customer:id,display_name','vendor:id,display_name',
                        'expense')
                    ->where('is_disabled',0)   
                    // ->where('fy',$request['fy'])
                    ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                    ->get();

                $total_amount=Transaction::where('account_id',$request['id'])
                        // ->where('organisation_id',$user['active_organisation'])
                        ->where('is_disabled',0)   
                        // ->where('fy',$request['fy'])
                        ->select(DB::raw('SUM(debit) as total_debit, SUM(credit) as total_credit'))->first();

                $totalDebit = $total_amount->total_debit ?: 0;
                $totalCredit = $total_amount->total_credit ?: 0;

                // Calculate Closing Balance
                $closingBalance = $totalDebit - $totalCredit;
            }

            $response = [

                'success' => true,

                'message' => 'Accounts Transactions fetched Successfully',

                'accounts' => $accounts,

                'total_amount'=>$total_amount,

                'closing_balance'=>$closingBalance,
                
                'active_organisation'=>$user['active_organisation'],

                'transactions' => $transactions,

            ];

            return response()->json($response);
        }
    }
    
    
    public function status(Request $request){
        // Validate Item
        $validator=validator($request->all(),[
           'id'=>'required|integer',
           'status'=>'required'
       ]);

       if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

       } else {

            try{
                $account =  Account::where('id',$request->input('id'))->first();
                $account['status']=$request['status'];
                $account->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'account'=>$account
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id found'], 404);
            }

           return response()->json($response);

       }
   }
   
   
    public function deleteAccount(Request $request)
    {
        $user=\Auth::user();

        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $account=Account::where('id', $request['id'])
                        // ->where('organisation_id',$user['active_organisation'])
                        ->first();

                if($account!=null){

                    if($account['lock_status']==0){

                        $account['is_disabled']=1;

                        $account->update();

                        $response=[
                            'success'=>true,
                            'message'=>'Account Deleted Successfully'
                        ];

                        return response()->json($response);

                    }else{

                        $response=[
                            'success'=>false,
                            'message'=>'Account Can not be deleted, It is locked'
                        ];

                        return response()->json($response);
                    }
                        
                }else{

                    return response()->json(['message' => 'Invalid Id found'], 404);
                }

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id found'], 404);
            }

        }
    }

     // Import Excel To database
     public function import(Request $request){
        // Validate Item
        $validator=validator($request->all(),[
            'file' => 'required|file'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
 
            $file = $request->file('file');

            Excel::import(new AccountsImport, $file);

            // Creating Activities
            $activity=new ActivityService;

            $activity->activityCreateUpdate('Accounts',0,'Imported');

            // return redirect()->back()->with('success', 'Accounts imported successfully!');

            $response=[
                'success'=>true,
                'message'=>'Accounts Excel Imported Successfully'
            ];

            return response()->json($response);
 
        }

    }
}
