<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccountType;
use App\Models\Currency;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\Address;
use App\Service\ActivityService;

class AccountTypeController extends Controller
{

    public function accountTypeCreateUpdate(Request $request){

        $auth=\Auth::user();

        $validator=validator($request->all(),[
            'account_type'=>'required',
            // 'account_group'=>'required',
            // 'user_id'=>'required|integer'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            // Account_group : Asset or Liablity 

            $data=[
                'account_type','account_group','account_type_formated','can_enable', 'can_show_opening_balance'
            ];
            
            foreach ($data as $key => $value) {
                if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                    $obj[$value]=$request[$value];
                }

                if($request[$value]==''){
                    $obj[$value]=null;
                }
            }

            if($request->id>0){

                try{

                    // $obj['user_id']=$user['id'];

                    $user_address=AccountType::where('id',$request->id)
                        // ->where('organisation_id',$auth['active_organisation'])
                        ->first();

                    // $user_address['is_shipping']=$request['is_shipping']??0;
                    // $user_address['is_billing']=$request['is_billing']??0;
                    
                    $user_address->update($obj);

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }
            }else{

                // $obj['user_id']=$request['user_id'];

                $user_address=AccountType::create($obj);

                // $check=$this->deactivateSetAddress($user_address['user_id']);

                // $user_address['is_shipping']=$request['is_shipping']??0;
                // $user_address['is_billing']=$request['is_billing']??0;

                // $user_address->update();
            }

            return response()->json(['status'=>200,'message'=>$request->id>0 ? 'AccountType update successfully':'AccountType Created Successfully',
            'account_type'=>$user_address],200);

        }
    }


    public function getAccountType(Request $request){
        $user=\Auth::user();

        $account_type=AccountType::query();

        $account_type=$account_type->where('is_disabled','0')->get();

        $response=[
            'success'=>true,
            'account_type'=>$account_type,
            'message'=>'All AccountType Listed Successfully'
        ];

        return response()->json($response);

    }

    public function deleteAccountType(Request $request){

        $user=\Auth::user();

        $validator=validator($request->all(),[
            'id'=>'required',
            'is_disabled'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            $account_type=AccountType::query();

            $account_type = $account_type->where('id', $request['id'])->update(['is_disabled' => $request['is_disabled']]);

            $response=[
                'success'=>true,
                'message'=>'AccountType Disabled Successfully'
            ];

            return response()->json($response);
        }
    }

}
