<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Brand;
use App\Service\ActivityService;
use Auth;

class BrandController extends Controller
{
    // create Update Brand
    public function brandCreateUpdate(Request $request)
    {
        $validator=validator($request->all(),[
            'name'=>'required|string',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $brand=[];

            $obj['name']=$request['name'];
            $obj['status']=1;

            if($request['id'] >0){

                try{

                    // Existing Id Then Update
                    $brand=Brand::findOrFail($request['id']);
                    $brand->update($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Brand',$brand['id'],'Updated');
                    
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else{

                // Check if Duplicate Brand
                if($obj['name'] != null && $obj['name'] != ''){
                    $checkName = Brand::where('name', $obj['name'])
                                    ->where('is_disabled', 0);

                    $checkName = $checkName->first();
                
                    if($checkName != null){
                        $response = [
                            'brand' => $checkName,
                            'success' => false,
                            'message' => 'Duplicate Name '. $checkName['name'] .' Found!'
                        ];
                
                        return response()->json($response);
                    }
                }

                // Create new Brand
                $brand=Brand::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Brand',$brand['id'],'Created');
            }
            $response=[
                'success'=>true,
                'message'=>$request['id']>0? "Brand Updated Successfully":"Brand Created Successfully",
                'data'=>$brand
            ];
        }

        return response()->json($response);
    }

    public function brandList(Request $request){

        // $user=Auth::user();
        
        $brand=Brand::where('is_disabled',0);

        if(isset($request['id']) && $request['id']>0){
            $brand=$brand->where('id',$request['id']);
        }

        if(isset($request['status']) && $request['status']!=''){
            $brand=$brand->where('status',$request['status']);
        }

        if($request['search']!=null && $request['search']!=''){

            $brand = $brand->where(function ($query) use ($request) {

                $query->where('name', 'LIKE', '%' . $request['search'] . '%');

            });
        }

        $count=$brand->count();

        $brand =$brand->orderBy('id','desc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$brand
        ];

        return response()->json($response);
    }

    public function delete(Request $request){

        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                $item = Brand::where('id', $request->input('id'))
                    ->firstOrFail(); // Use firstOrFail() to throw ModelNotFoundException if not found
    
                $item->is_disabled = 1;
                $item->save(); // Use save() method to persist changes to the database
            
                $response = [
                    'success' => true,
                    'message' => 'Brand Deleted successfully.'
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            return response()->json($response);
        }
    }


    public function status(Request $request){
        // $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required',
            'status'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                $item = Brand::where('id', $request->input('id'))
                    // ->where('organisation_id', $user['active_organisation'])
                    ->firstOrFail(); // Use firstOrFail() to throw ModelNotFoundException if not found
    
                $item->status = $request['status'];
                $item->save(); // Use save() method to persist changes to the database
            
                $response = [
                    'success' => true,
                    'message' => 'Brand Status Updated successfully.'
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            return response()->json($response);
        }
    }
}
