<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CurrencyRate; // Assuming CurrencyRate model is created
use Auth;
use Carbon\Carbon;

class CurrencyController extends Controller
{
    // public function storeOrUpdateCurrencies(Request $request)
    // {
    //     $currenciesData = $request->input('currencies');

    //     // Validate the incoming data
    //     $validatedData = $request->validate([
    //         'currencies' => 'required|array',
    //         'currencies.*.date' => 'required|date',
    //         'currencies.*.currency_id' => 'required|integer',
    //         'currencies.*.currency_name' => 'required|string',
    //         'currencies.*.code' => 'required|string',
    //         'currencies.*.country' => 'required|string',
    //         'currencies.*.symbol' => 'required|string',
    //         'currencies.*.current_rate' => 'required|numeric',
    //         'currencies.*.exchange_rate' => 'required|numeric',
    //         'currencies.*.id' => 'nullable|integer',
    //     ]);

    //     foreach ($currenciesData as $currency) {
    //         // Check if an entry with the same date exists and the ID is not provided (new entry)
    //         if (empty($currency['id']) && CurrencyRate::where('date', $currency['date'])->where('currency_id', $currency['currency_id'])
    //             ->where('currency_name',$currency['currency_name'])->exists()) {
    //             return response()->json(['success'=>false,'message'=> 'Entry with the same date and currency ID already exists.'], 200);
    //         }

    //         if (!empty($currency['id']) && $currency['id'] > 0) {
    //             // Update existing record
    //             $existingCurrency = CurrencyRate::find($currency['id']);
    //             if ($existingCurrency) {
    //                 $existingCurrency->update([
    //                     'date' => $currency['date'],
    //                     'currency_id' => $currency['currency_id'],
    //                     'currency_name' => $currency['currency_name'],
    //                     'code' => $currency['code'],
    //                     'country' => $currency['country'],
    //                     'symbol' => $currency['symbol'],
    //                     'current_rate' => $currency['current_rate'],
    //                     'exchange_rate' => $currency['exchange_rate'],
    //                 ]);
    //             } else {
    //                 return response()->json(['success'=>false,'message' => 'Currency entry not found for update.'], 200);
    //             }
    //         } else {
    //             // Save new entry
    //             CurrencyRate::create([
    //                 'date' => $currency['date'],
    //                 'currency_id' => $currency['currency_id'],
    //                 'currency_name' => $currency['currency_name'],
    //                 'code' => $currency['code'],
    //                 'country' => $currency['country'],
    //                 'symbol' => $currency['symbol'],
    //                 'current_rate' => $currency['current_rate'],
    //                 'exchange_rate' => $currency['exchange_rate'],
    //             ]);
    //         }
    //     }

    //     return response()->json(['success'=>true,'message' => 'Currencies saved or updated successfully.'], 200);
    // }

    public function storeOrUpdateCurrencies(Request $request)
    {
        $currenciesData = $request->input('currencies');

        $validatedData = $request->validate([
            'currencies' => 'required|array',
            'currencies.*.from_date' => 'required|date',
            'currencies.*.to_date' => 'required|date|after_or_equal:currencies.*.from_date',
            'currencies.*.currency_id' => 'required|integer',
            'currencies.*.currency_name' => 'required|string',
            'currencies.*.code' => 'required|string',
            'currencies.*.country' => 'required|string',
            'currencies.*.symbol' => 'required|string',
            'currencies.*.current_rate' => 'required|numeric',
            'currencies.*.exchange_rate' => 'required|numeric',
            // 'currencies.*.id' => 'nullable|integer',
        ]);

        foreach ($currenciesData as $currency) {
            $startDate = \Carbon\Carbon::parse($currency['from_date']);
            $endDate   = \Carbon\Carbon::parse($currency['to_date']);

            // Loop through each date in range
            for ($date = $startDate->copy(); $date->lte($endDate); $date->addDay()) {
                $existing = CurrencyRate::where('date', $date->toDateString())
                    ->where('currency_id', $currency['currency_id'])
                    ->first();

                if ($existing) {
                    $existing->update([
                        'code' => $currency['code'],
                        'country' => $currency['country'],
                        'symbol' => $currency['symbol'],
                        'current_rate' => $currency['current_rate'],
                        'exchange_rate' => $currency['exchange_rate'],
                    ]);
                } else {
                    CurrencyRate::create([
                        'date' => $date->toDateString(),
                        'currency_id' => $currency['currency_id'],
                        'currency_name' => $currency['currency_name'],
                        'code' => $currency['code'],
                        'country' => $currency['country'],
                        'symbol' => $currency['symbol'],
                        'current_rate' => $currency['current_rate'],
                        'exchange_rate' => $currency['exchange_rate'],
                    ]);
                }
            }
        }

        return response()->json(['success' => true, 'message' => 'Currencies saved or updated successfully.'], 200);
    }




    public function getCurrenciesByDate(Request $request)
    {
        $validatedData = $request->validate([
            'date' => 'required|date',
        ]);

        $date = $validatedData['date'];

        $currencies = CurrencyRate::where('date', $date)->get();

        if ($currencies->isEmpty()) {
            return response()->json(['success'=>false,'message' => 'No currencies found for the specified date.'], 200);
        }

        return response()->json(['success'=>true,'message' =>"Currencies Listed",'data' => $currencies], 200);
    }

    // Showing all Curiencies Dates where data recorded
    public function currencyAllDates(Request $request)
    {
        $currencies = CurrencyRate::select('date')->distinct()->get();
        return response()->json(['success'=>true,'message' =>"Currencies Listed dates",'data' => $currencies], 200);
    }
}
