<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\User;

class DashboardController extends Controller
{
    public function getDashboardSummary(Request $request)
    {
        //For balance summary of customer and vendors
        $customer_balance=User::where('is_customer',1)->sum('balance');
        $vendor_balance=User::where('is_vendor',1)->sum('balance');

        return response()->json([
            'invoices'  => $this->getCounts('invoices'),
            // 'payments'  => $this->getCounts('payments'),
            'bills'     => $this->getCounts('bills'),
            'customers' => $this->getCustomerCounts('users'),
            'vendors'   => $this->getVendorCounts('users'),
            'dsr'       => $this->getdsrMiceCounts('dsrs'),
            'mice'      => $this->getdsrMiceCounts('mices'),
            'receviables'=>$customer_balance,
            'payables'=>$vendor_balance

        ]);
    }

    //   * Get status counts for a table (numeric status)
    //  */
    private function getCounts($table)
    {
        $rawCounts = DB::table($table)
            ->select('status', DB::raw('COUNT(*) as total'))
            ->groupBy('status')
            ->get();

            // Step 2: Initialize all statuses 0–6 with 0
        $counts = [];
        foreach (range(0, 6) as $status) {
            $counts[(string)$status] = 0;
        }

        // Step 3: Replace with actual totals where available
        foreach ($rawCounts as $row) {
            $counts[(string)$row->status] = $row->total;
        }

        return $counts;
    }

    private function getdsrMiceCounts($table)
    {
        $rawCounts = DB::table($table)
            ->select('is_invoiced', DB::raw('COUNT(*) as total'))
            ->groupBy('is_invoiced')
            ->get();

            // Step 2: Initialize all is_invoiced 0–6 with 0
        $counts = [];
        foreach (range(0, 3) as $is_invoiced) {
            $counts[(string)$is_invoiced] = 0;
        }

        // Step 3: Replace with actual totals where available
        foreach ($rawCounts as $row) {
            $counts[(string)$row->is_invoiced] = $row->total;
        }

        return $counts;
    }

     private function getVendorCounts($table)
    {
        $rawCounts = DB::table($table)
            ->select('status', DB::raw('COUNT(*) as total'))
            ->where('is_disabled',0)
            ->where('is_vendor',1)
            ->groupBy('status')
            ->get();

            // Step 2: Initialize all statuses 0–6 with 0
        $counts = [];
        foreach (range(0, 6) as $status) {
            $counts[(string)$status] = 0;
        }

        // Step 3: Replace with actual totals where available
        foreach ($rawCounts as $row) {
            $counts[(string)$row->status] = $row->total;
        }

        return $counts;
    }

    private function getCustomerCounts($table)
    {
        $rawCounts = DB::table($table)
            ->select('status', DB::raw('COUNT(*) as total'))
            ->where('is_disabled',0)
            ->where('is_customer',1)
            ->groupBy('status')
            ->get();

            // Step 2: Initialize all statuses 0–6 with 0
        $counts = [];
        foreach (range(0, 6) as $status) {
            $counts[(string)$status] = 0;
        }

        // Step 3: Replace with actual totals where available
        foreach ($rawCounts as $row) {
            $counts[(string)$row->status] = $row->total;
        }

        return $counts;
    }
}
