<?php

namespace App\Http\Controllers\Api\Database;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Log;
use App\Models\User;
use App\Models\SequenceFormat;

class DatabaseController extends Controller
{
    function backupAndTruncateAllExcept()
    {

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        $excludedTables=['accounts','account_types','account_groups','airports','brands','cities','countries','currencies','container_types',
            'expense_heads','failed_jobs','hotels','hotel_prices','rooms','room_prices','insurances',
            'masters','migrations','organisations','organisation_role_permissions','password_resets','personal_access_tokens',
            'sequence_formats','sessions','states','stores','tax_rates','users','user_invites','user_masters','user_organisations',
            'vehicles','trailers','warehouses','financial_statement_heads','help_centers',
            // Services
            'tour_packages','tour_destinations','tour_others','tour_travel','visas','itineraries','itinerary_rows','flights',
            'car_hire','assists','insurances'];

        $tables = DB::select('SHOW TABLES');
        $dbName = env('DB_DATABASE');
        
        foreach ($tables as $table) {
            $tableName = reset($table);
            
            if (!in_array($tableName, $excludedTables)) {
                DB::table($tableName)->truncate();
            }
        }
        

        User::where('is_customer', 1)
            ->orWhere('is_vendor', 1)
            // ->orWhere('is_employee', 1)
            // ->orWhere('is_logistics', 1)
            // ->orWhere('is_container_owner', 1)
            // ->orWhere('is_driver', 1)
            ->delete();

        User::query()->update(['balance'=>0]);

        SequenceFormat::query()->update(['sequence_number' =>1, 'start_sequence' =>1]);

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        dd("Megamarket Database Backup and Truncate Successfully");
    }
}
