<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\StreamedResponse;

class DatabaseController extends Controller
{
    public function export()
    {
        // Database credentials
        $database = env('DB_DATABASE');
        $username = env('DB_USERNAME');
        $password = env('DB_PASSWORD');
        $host = env('DB_HOST');

        // File path and name
        $fileName = "backup-" . now()->format('Y-m-d_H-i-s') . ".sql";
        $filePath = storage_path("app/{$fileName}");

        // Command to export the database
        $command = "mysqldump --user={$username} --password={$password} --host={$host} {$database} > {$filePath}";

        // Execute the command
        $output = null;
        $returnVar = null;
        exec($command, $output, $returnVar);

        // Check if the export was successful
        if ($returnVar !== 0) {
            return response()->json(['error' => 'Database export failed.'], 500);
        }

        // Stream the file as a download response
        return response()->download($filePath)->deleteFileAfterSend(true);
    }
}