<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Document;

class DocumentController extends Controller
{
     public function documentCreateUpadate(Request $request)
    {
         $validator = validator($request->all(), [
            'date' => 'required',
            'document_name' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
            ], 200);
        }

        $obj['date'] = $request['date'];
        $obj['document_name'] = $request['document_name']??null;
        $obj['upload_documents'] = $request['upload_documents']??null;
        $obj['is_module'] = 1;

        if($request['id']>0){
            $document = Document::find($request['id']);
            $document->update($obj);
            return response()->json([
                'success' => true,
                'message' => 'Document updated successfully',
                'data' => $document
            ], 200);
        }else{
            $document = Document::create($obj);
            return response()->json([
                'success' => true,
                'message' => 'Document uploaded successfully',
                'data' => $document
            ], 200);
        }

        $response=[
            'success' => true,
            'message' => 'Document uploaded successfully',
            'data' => $document
        ];

        return response()->json($response, 200);
    }

    public function documentList(Request $request)
    {
        $documents = Document::where('is_module', 1)->where('is_deleted', 0)->get();
        return response()->json([
            'success' => true,
            'message' => 'Document list fetched successfully',
            'data' => $documents
        ], 200);
    }

    public function documentDetails(Request $request)
    {
         $validator = validator($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
            ], 200);
        }
        $document = Document::find($request->id);
        return response()->json([
            'success' => true,
            'message' => 'Document details fetched successfully',
            'data' => $document
        ], 200);
    }

    public function deleteDocument(Request $request)
    {
        $validator = validator($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
            ], 200);
        }
        $document = Document::find($request->id);
        if($document){
            
            $document['is_deleted']=1;
            $document->save();
            
            return response()->json(['success' => 'Document deleted successfully']);
        } else {
            return response()->json(['error' => 'Document not found']);
        }
    }

}
