<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\ExpenseHead;

use App\Models\Expense;

use Auth;

use App\Service\AccountsTransactionService;
use App\Service\StaticMaster;

use App\Service\ActivityService;
use App\Service\SequenceService;
use App\Models\Transaction;

class ExpenseController extends Controller
{

    // Creating and Updating expense head.
    public function createExpenseHead(Request $request){

         // Validation user and name  of organisation
        $validator=validator($request->all(),[
            'expense_type'=>'required',
            'expense_name'=>'required' // this will validate user_id exists in users table
        ]);



        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            $obj['expense_type']=$request['expense_type'];  //1. Direct expense 2. In direct expense
            $obj['expense_name']=$request['expense_name'];

            if($request['id']>0)   // update existing record

            {

                try{

                    $expense_head=ExpenseHead::findOrFail($request['id']);
                    $expense_head->update($obj);

                    // Creating Activities

                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Expense head',$expense_head['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else {

                // create new Expense Head
                $expense_head=ExpenseHead::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Expense Head',$expense_head['id'],'Created');

            }

            $response=[
                "data"=>$expense_head,
                "success"=>true,
                "message"=>"Expense Head Saved Successfully",
            ];

            return response()->json($response);
        }

    }

    // Showing Expense Heads
    public function  listExpensesHead(Request $request){

        $user=Auth::user();

        // Log::info($user['active_organisation']);

        $expense_head=ExpenseHead::where('organisation_id',$user['active_organisation'])->get();

        $response = ["data" => $expense_head,"success" => true];

        return response()->json($response);

    }

    // Creating Expenses
    public function createUpdateExpense(Request $request){

          // Validation user and name  of organisation

          $validator=validator($request->all(),[

            'expense_head_id'=>'required',
            'transaction_date'=>'required', // this will validate user_id exists in users table
            'amount'=>'required' ,
            // 'paid_by'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            $obj['expense_head_id']=$request['expense_head_id']??0;
            $obj['description']=$request['description'];
            $obj['customer_id']=$request['customer_id']??0;
            $obj['vendor_id']=$request['vendor_id']??0;
            $obj['display_name']=$request['display_name'];
            $obj['amount']=$request['amount']??0.0;
            $obj['transaction_date']=$request['transaction_date'];
            $obj['transaction_type']=StaticMaster::$EXPENSE;
            $obj['paid_by']=$request['paid_by']??0;
            $obj['acc_id']=$request['acc_id']??0;
            $obj['notes']=$request['notes'];
            $obj['customer_name']=$request['customer_name'];
            $obj['document']=$request['document'];
            $obj['currency']=$request['currency']??null;
            $obj['currency_symbol']=$request['currency_symbol']??null;
            $obj['tax_amount']=$request['tax_amount']??0.0;  
            $obj['tax_percent']=$request['tax_percent']??0;
            $obj['user_type']=$request['user_type']??0;   //1 for customer and 2 for vendor

            if($request['id']>0){

            try{

                    $expense=Expense::findOrFail($request['id']);
                    $expense->update($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Expenses',$expense['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else {

                $expense=Expense::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Expenses',$expense['id'],'Created');

                $module='expenses';

                // Update Sequence Number
                $sequence=new SequenceService;
                $sequence->updateSequence($module);
            }

            $response=[
                "success"=>true,
                "expense"=>$expense,
                'Expense'=>$request['id']>0?'Expense Updated Successfully':'Expense Created Successfully'
            ];

            return response()->json($response);

        }

    }

    public function getExpense(Request $request){

        $user=Auth::user();

        $expense=Expense::where('organisation_id',$user['active_organisation'])

            ->with('expense_head:id,expense_name,expense_type','expense_account:id,account_name','paid_through:id,account_name')

            ->where('rolledback',0);

        if ($request['status']!='' && isset($request['status'])) {

            $expense=$expense->where('status',$request['status']);

        }
        if($request['search']!=null && $request['search']!=''){

            // $searchTerm = $request['search'];

            $expense = $expense->where(function ($query) use ($request) {

                $query->where('amount', 'LIKE', '%' . $request['search'] . '%')

                    ->orWhereHas('expense_head',function($q) use ($request){
                        $q->where('expense_name', 'LIKE', '%' . $request['search'] . '%');
                    })

                    ->orWhereHas('expense_account',function($q) use ($request){
                        $q->where('account_name', 'LIKE', '%' . $request['search'] . '%');
                    })

                    ->orWhereHas('paid_through',function($q) use ($request){
                        $q->where('account_name', 'LIKE', '%' . $request['search'] . '%');
                    });
                   
            });

        }

        if ($request['customer_id']!=0 && $request['customer_id']!='' && isset($request['customer_id'])) {
    
            $expense = $expense->where('customer_id',$request['customer_id']);

        }

        if ($request['vendor_id']!=0 && $request['vendor_id']!='' && isset($request['vendor_id'])) {
    
            $expense = $expense->where('vendor_id',$request['vendor_id']);

        }
        // get custom_date data by transaction_date

        if ($request['custom_date']!='' && isset($request['custom_date'])) {

            $customDate = $request->custom_date;

            $expense = $expense->whereDate('transaction_date', $customDate);

        }

        // get fromDate toDate data by created_at

        if ($request['from_date']!='' && isset($request['to_date'])) {

            $fromDate = $request->from_date;

            $toDate = $request->to_date;

            // 'fromDate' and 'toDate'
            $expense = $expense->whereBetween('transaction_date', [$fromDate, $toDate]);

        }

        $count=$expense->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
            
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $expense = $expense->orderby($request['sort_by'],$sort_order);

        }else{
            $expense = $expense->orderby('id','desc');
        }

        $expense=$expense->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                        ->get();

        $response=[
            'message'=>'Expense List Fetched Successfully',
            'count'=>$count,
            'success'=>true,
            'expense'=>$expense
        ];

        return response()->json($response);

    }

    public function details(Request $request){
         // Validation user and name  of organisation

         $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

                $expense = Expense::where('id',$request['id'])
                    ->with('expense_head:id,expense_name','expense_account:id,account_name','paid_through:id,account_name',
                    'customer','vendor')
                    ->first();

                $transaction=Transaction::where('transaction_id',$request['id'])
                    ->where('entity_type','expense')
                    ->where('transaction_type',StaticMaster::$EXPENSE)
                    ->with('account:id,account_name,account_code')
                    ->get();

                $response=[
                    'message'=>'Details Fetched Successfully',
                    'success'=>true,
                    'transaction'=>$transaction,
                    'expense'=>$expense,
                ];

                return response()->json($response);
        }
    }

    public function approveExpense(Request $request){

        $validator=Validator::make($request->all(),[

            'id'=>'required'

        ]);

        if ($validator->fails()) {

            # code...

    
            $response=[ 

                'success'=>false,

                'message'=>$validator->errors()->first()
            ];

            return response()->json($response);    

        }

        else{

            try{

                $transaction = Expense::findOrFail($request->invoice_id);

                $transaction['is_approved']=1;

                $transaction->update();  

                 // Creating Activities

                 $activity=new ActivityService;

                 $activity->activityCreateUpdate('Expenses',$expense['id'],'Approved');

                // $stockEntryService = new StockEntryService;

                // $stockEntryService->saveStockEntries( $transaction,$entity,2);

                // Saving Accounts Entries
                $accountsEntryService = new AccountsTransactionService;
                $accountsEntryService->expense_accounts_transaction($transaction);
                

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id to update '], 404);

            }

        }

        $response=[ 

            'success'=>true,

            'message'=>'Expense Approved Successfully'

        ];



        return response()->json($response);

    }

    public function statusExpense(Request $request){
        // Validate Item
        $status_change='';

        $validator=validator($request->all(),[

            'id'=>'required',
            'status'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {
            $transaction = Expense::findOrFail($request->id);

            $transaction['status']=$request['status'];

            if($request['status']==1){
                $status_change='Approved';
                $transaction['is_approved']=1;

                // Saving Accounts Entries
                $accountsEntryService = new AccountsTransactionService;
                $accountsEntryService->expense_accounts_transaction($transaction);
            }
            if($request['status']==2){
                $status_change='Declined';
                $transaction['is_approved']=0;
            }
            if($request['status']==0){
                $status_change='Draft';
            }

            $transaction->update();  

            $response=[ 

                'success'=>true,
    
                'message'=>'Expense '.$status_change.' Updated Successfully'
    
            ];

            return response()->json($response);

        }
    }

    public function destroy(Request $request)
    {

        $user=Auth::user();

        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            try{
                $expense = Expense::findOrFail($request['id']);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to delete '], 404);
            }

            if($expense['is_approved']==0){

                $expense['rolledback']=1;

                $expense->update();

                $response=[
                    'success'=>true,
                    'message'=>'Expense deleted Successfully'
                ];

            }else{

                $response=[
                    'success'=>false,
                    'message'=>'Expense is Approved. You can\'t delete this Expense.'
                ];

            }

            return response()->json($response);
        }
    }

}

