<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FinancialStatementHead;
use Validation;
use App\Models\Account;

class FinancialStatementHeadController extends Controller
{
    // create Update 
    public function createUpdateFinancialHead(Request $request){
        $validator=validator($request->all(),[

            'head_name'=>'required|string',
            // 'account_ids'=>'required',
            // 'unit'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $obj['head_name']=$request['head_name'];
            $obj['account_ids']=$request['account_ids'];
            $obj['head_type']=$request['head_type'];  //'Asset' or 'Liability'
            $obj['sub_head_name']=$request['sub_head_name']??null;     // Financial head id          
            $obj['sub_head_id']=$request['sub_head_id']??0;     // Financial head id          
            $obj['is_profit_loss']=$request['is_profit_loss']??0;
            $obj['is_balancesheet']=$request['is_balancesheet']??0;
            $obj['is_cfs']=$request['is_cfs']??0;
            $obj['version']=$request['version']??1;

            if($request['id']>0){

                try {
                    
                    $financialHead=FinancialStatementHead::findOrFail($request['id']);
                    $financialHead->update($obj);
                //
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    return [
                        'success' => false, 
                        'message' => 'Financial Head Statement Not Found'
                    ];
                }

                return [
                    'success' => true, 
                    'message' => 'Financial Head Updated Successfully',
                    'data' => $financialHead
                ];

            }else{

                $financialHead=FinancialStatementHead::create($obj);
                return [
                    'success' => true, 
                    'message' => 'Financial Head Created Successfully',
                    'data' => $financialHead
                ];
            }

        }
    }

    //List of financial Statement Head
    public function financialHeadList(Request $request){
        $financialHead=FinancialStatementHead::where('is_deleted',0);

        if($request['is_balancesheet']==1){
            $financialHead=$financialHead->where('is_balancesheet',1);
        }

        if($request['is_profit_loss']==1){
            $financialHead=$financialHead->where('is_profit_loss',1);
        }

        if($request['is_cfs']==1){
            $financialHead=$financialHead->where('is_cfs',1);
        }

        $financialHead=$financialHead->get();
        return [
            'success' => true, 
            'message' => 'Financial Head List',
            'data' => $financialHead
        ];
    }

    // Details Financial Statement Head
    public function financialHeadDetails(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required|integer'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            try {
                
                $financialHead=FinancialStatementHead::findOrFail($request['id']);

                $account_ids = json_decode($financialHead->account_ids, true);
                $account_ids = is_array($account_ids) ? $account_ids : [];

                // Getting All accounts details with ids
                $accounts=Account::whereIn('id',$account_ids)->get();
                
                $financialHead->accounts = $accounts;
            //
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return [
                    'success' => false, 
                    'message' => 'Financial Head Statement Not Found'
                ];
            }

            return [
                'success' => true, 
                'message' => 'Financial Head Details',
                'data' => $financialHead
            ];
        }
    }

    //Delete financial Statement Head
    public function deleteFinancialHead(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required|integer'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $financialHead=FinancialStatementHead::findOrFail($request['id']);
            $financialHead->update(['is_deleted'=>1]);
            return [
                'success' => true, 
                'message' => 'Financial Head Deleted Successfully'
            ];
        }
    }
}
