<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HelpCenter;
use Auth;
use Log;

class HelpCenterController extends Controller
{
    public function helpCreateUpdate(Request $request){

        // Validation user and name  of organisation
        $validator=validator($request->all(),[
            'issue_type_id'=>'required',
            'date'=>'required'
        ]);
        
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {    

            $obj['date']=$request['date'];
            $obj['issue_type_id']=$request['issue_type_id'];
            $obj['issue_type_name']=$request['issue_type_name'];
            $obj['module_id']=$request['module_id']??0;
            $obj['module_name']=$request['module_name'];
            $obj['page_url']=$request['page_url'];
            $obj['priority']=$request['priority'];
            $obj['upload_documents']=$request['upload_documents'];
            $obj['comments']=$request['comments'];
            $obj['is_accounts']=$request['is_accounts']??0;
            $obj['is_manufacturing']=$request['is_manufacturing']??0;
            $obj['developer_comment']=$request['developer_comment'];
            $obj['audio_url']=$request['audio_url'];

            // for Megamarket
            if($request['is_tms']==1){
                $obj['is_tms']=$request['is_tms'];
            }
            
            if(isset($request['id']) && $request['id']>0){

                try {
                    
                    $help_center=HelpCenter::findOrFail($request['id']);
                    $help_center->update($obj);

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }

            }else{
                $help_center=HelpCenter::create($obj);
            }

            $response=[

                "data"=>$help_center,
                "success"=>true,
                "message"=>$request['id']>0?"Help Updated Successfully":"Help Recorded Successfully",
            ];

            return response()->json($response);
        }
    }

    public function help_list(Request $request){
       
            $help_center=HelpCenter::where('rolledback',0);

            if(isset($request['status']) && $request['status']==0){
                $help_center=$help_center->where('status',$request['status']);
            }
            if(isset($request['status']) && $request['status']==1){
                $help_center=$help_center->where('status',$request['status']);
            }
            if(isset($request['status']) && $request['status']==2){
                $help_center=$help_center->where('status',$request['status']);
            }

            if($request['search']!=null && $request['search']!=''){

                // $searchTerm = $request['search'];
                $help_center = $help_center->where(function ($query) use ($request) {
    
                    $query->where('module_name', 'LIKE', '%' . $request['search'] . '%')
                        ->orWhere('issue_type_name', 'LIKE', '%' . $request['search'] . '%')
                        ->orWhere('priority', 'LIKE', '%' . $request['search'] . '%')
                        ->orWhere('page_url', 'LIKE', '%' . $request['search'] . '%');
                       
                });
            }

            if ($request['custom_date']!='' && isset($request['custom_date'])) {

                $customDate = $request->custom_date;
    
                $help_center = $help_center->whereDate('date', $customDate);
    
            }
    
            if ($request['from_date']!='' && isset($request['to_date'])) {
    
                $fromDate = $request->from_date;
    
                $toDate = $request->to_date;
    
                // 'fromDate' and 'toDate'
                $help_center = $help_center->whereBetween('date', [$fromDate, $toDate]);
              
            }

            if($request['priority']!=0 && $request['priority']!=''){
                $help_center=$help_center->where('priority',$request['priority']);
            }

            if($request['is_accounts']!=0 && $request['is_accounts']!=''){
                $help_center=$help_center->where('is_accounts',$request['is_accounts']);
            }

            if($request['is_tms']!=0 && $request['is_tms']!=''){
                $help_center=$help_center->where('is_tms',$request['is_tms']);
            }

            if($request['is_manufacturing']!=0 && $request['is_manufacturing']!=''){
                $help_center=$help_center->where('is_manufacturing',$request['is_manufacturing']);
            }

            if($request['is_logistics']!=0 && $request['is_logistics']!=''){
                $help_center=$help_center->where('is_logistics',$request['is_logistics']);
            }

            if($request['is_workshop']!=0 && $request['is_workshop']!=''){
                $help_center=$help_center->where('is_workshop',$request['is_workshop']);
            }

            $count=$help_center->count();

            if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
                $sort_order=$request['sort_order']==1?'asc':'desc';

                $help_center = $help_center->orderby($request['sort_by'],$sort_order);

            }else{
                $help_center = $help_center->orderby('id','desc');
            }

            $help_center=$help_center->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                        ->get();

            $response=[
                'message'=>'Help Center List Fetched Successfully',
                'count'=>$count,
                'success'=>true,
                'help_center'=>$help_center
            ];

            return response()->json($response);

        
    }

    public function help_details(Request $request){
        // Log::info("Help Center Details");
         $validator=validator($request->all(),[
            'id'=>'required'
        ]);
        
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        }
        try {
            $help_center=HelpCenter::findOrFail($request['id']);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['success'=>false,'message' => 'Invalid Id to fetch '], 404);
        }

        $response=[
            'message'=>'Help Center Details Fetched Successfully',
            'success'=>true,
            'help_center'=>$help_center
        ];

        return response()->json($response);
    }

    public function updateStatus(Request $request){
        $user=Auth::user();

        // Validation user and name  of organisation
        $validator=validator($request->all(),[
            'id'=>'required|integer',
            'status'=>'required|integer'
        ]);
        
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else { 
            
            try{

                $help_center=HelpCenter::findOrFail($request['id']);

                if($user['is_admin']==1){

                    $help_center['status']=$request['status'];

                    $help_center->update();

                }else{
                    return response()->json(['success'=>false,'message' => 'Only Developers Can Change Status'], 404);
                }

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[

                "data"=>$help_center,
                "success"=>true,
                "message"=>"Help Center Status Updated Successfully",
            ];

            return response()->json($response);
        }
    }

    //Update Developer Comment 
    public function updateDeveloperComment(Request $request){
        $user=Auth::user();

        // Validation user and name  of organisation
        $validator=validator($request->all(),[
            'id'=>'required|integer',
            'developer_comment'=>'required|string'
        ]);
        
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else { 
            
            try{

                $help_center=HelpCenter::findOrFail($request['id']);

                if($user['is_admin']==1){

                    $help_center['developer_comment']=$request['developer_comment'];

                    $help_center->update();

                }else{
                    return response()->json(['success'=>false,'message' => 'Only Developers Can Change Status'], 404);
                }

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[

                "data"=>$help_center,
                "success"=>true,
                "message"=>"Help Center Status Updated Successfully",
            ];

            return response()->json($response);
        }
    }
}
