<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \App\Models\Hrms\Announcement;
use Validator;
use Auth;

class AnnouncementController extends Controller
{
    
    public function announcementCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'subject'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'subject','expiry','attachment',
                    'notify_all','notify_any_others','description',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['attachment'] = isset($request['attachment']) ? json_encode($request['attachment']) : null;
                $obj['notify_any_others'] = isset($request['notify_any_others']) ? json_encode($request['notify_any_others']) : null;

                if($request->id>0){

                    try{
                        $announcement=Announcement::findOrFail($request['id']);
                        $announcement->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $announcement=Announcement::create($obj);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Announcement update successfully':'Announcement Created Successfully',
                    'announcement'=>$announcement
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


    public function getAnnouncement(Request $request){

        $user=Auth::user();

        if($user!=null){

            $announcementList=Announcement::where('is_disabled','0')
                ->with('enteredby')
               ->where('organisation_id',$user['active_organisation']);

            $announcementList=$this->fetchuserbyquery($announcementList,$request);
            $count=$announcementList->count();
            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc'; // "sortOrder":0 for asc and "sortOrder":1 for desc
            $sortBy = $request['sortBy'] ?? 'id'; // Default to 'id' if 'sortBy' is not provided

            $announcementList = $announcementList->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'announcement'=>$announcementList,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'announcement'=>$announcementList,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($announcementList,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $announcementList = $announcementList->whereRaw(" (subject like ? or description like ? or notify_all like ?) ", array($keyword , $keyword , $keyword));
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $announcementList = $announcementList->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $announcementList = $announcementList->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $announcementList;
    }

    public function detailsAnnouncement(Request $request){

        $auth=Auth::user();

        try{

            $announcement=Announcement::where('id',$request['id'])
                ->where('organisation_id',$auth['active_organisation'])
                ->with('enteredby')
                ->first();

            $response=[
                'success'=>true,
                'announcement'=>$announcement
            ];

            return response()->json($response);

        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }

    public function deleteAnnouncement(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $announcement =  Announcement::where('id',$request->input('id'))
                                        ->where('organisation_id',$auth['active_organisation'])
                                        ->first();

                $announcement['is_disabled']='1';
                $announcement->update();

                $response=[
                    'success'=>true,
                    'message'=>'Announcement Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }


}
