<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use App\Models\Hrms\Employee;
use App\Models\Hrms\Applicant;
use App\Models\User;
use Validator;
use Auth;

class ApplicantController extends Controller
{

    public function applicantCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'name'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'name',
                    'email',
                    'mobile_no',
                    'job_opening_id',
                    'job_opening_name',
                    'country_id',
                    'state_id',
                    'city_id',
                    'zip_code',
                    'source',
                    'referred_by',
                    'expected_salary',
                    'availability_date',
                    'status',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['resume'] = isset($request['resume']) ? json_encode($request['resume']) : null;
                $obj['cover_letter'] = isset($request['cover_letter']) ? json_encode($request['cover_letter']) : null;

                if($request->id>0){

                    try{

                        $user=Applicant::findOrFail($request['id']);
                        $user->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $user=Applicant::create($obj);

                    // Log::info($user);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Applicant update successfully':'Applicant Created Successfully',
                    'result'=>$user
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


    public function getApplicant(Request $request){

        $user=Auth::user();

        if($user!=null){

            $userlist=Applicant::where('is_disabled','0')->with('country:id,name','state:id,name','city:id,name')
                ->where('organisation_id',$user['active_organisation']);

            $userlist=$this->fetchuserbyquery($userlist,$request);
            $count=$userlist->count();
            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc'; // "sortOrder":0 for asc and "sortOrder":1 for desc
            $sortBy = $request['sortBy'] ?? 'id'; // Default to 'id' if 'sortBy' is not provided
            
            $userlist = $userlist->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$userlist,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$userlist,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($userlist,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $userlist = $userlist->whereRaw(" (name like ? or email like ? or mobile_no	like ? or job_opening_name like ?) ", array($keyword , $keyword , $keyword , $keyword));
        }

        if($request['status']!='' && isset($request['status'])){
            $userlist=$userlist->where('status',$request['status']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $userlist = $userlist->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $userlist = $userlist->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $userlist;
    }

    public function getApplicantdetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $user = Applicant::where('id', $request->id)->with('country:id,name','state:id,name','city:id,name')
                        ->where('organisation_id', $auth->active_organisation) 
                        ->first();
    
        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'Applicant not found'
            ], 404);
        }
    
        $response = [
            'result' => $user,
            'success' => true,
            'message' => 'Applicant Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
    
    public function deleteApplicant(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $user =  Applicant::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$user) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Applicant not found'
                    ], 404);
                }

                $user['is_disabled']='1';
                $user->update();

                $response=[
                    'success'=>true,
                    'message'=>'Applicant Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }

    public function updateStatusApplicant(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'id'=>'required|integer'
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $user = Applicant::where('id',$request->input('id'))->first();
                $user['status']=$request['status'];
                $user->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$user
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

}
