<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use App\Models\Hrms\Employee;
use App\Models\Hrms\Client;
use App\Models\User;
use Validator;
use Auth;

class ClientController extends Controller
{

    public function clientCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'full_name'=>'required',
            'email'=>'required',
            'mobile_no'=>'required',
            'designation'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'full_name','email','gender','company_name','designation','mobile_no',
                    'company_no','client_image','website','client_address','description',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['client_image'] = isset($request['client_image']) ? json_encode($request['client_image']) : null;

                if($request->id>0){

                    try{

                        $client=Client::findOrFail($request['id']);
                        $client->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{
                
                    $client=Client::create($obj);
                    // Log::info($client);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Client update successfully':'Client Created Successfully',
                    'result'=>$client
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

    public function getClient(Request $request){

        $user=Auth::user();

        if($user!=null){

            $clientList=Client::where('is_disabled','0')
                ->where('organisation_id',$user['active_organisation']);

            $clientList=$this->fetchuserbyquery($clientList,$request);
            $count=$clientList->count();

            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';

            $clientList = $clientList->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$clientList,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$clientList,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($clientList,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $clientList = $clientList->whereRaw(" (full_name like ? or mobile_no like ? or company_name like ?) ", array($keyword , $keyword, $keyword));
        }

        if($request['status']!='' && isset($request['status'])){
            $clientList=$clientList->where('status',$request['status']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $clientList = $clientList->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $clientList = $clientList->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $clientList;
    }

    public function getClientdetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $client = Client::where('id', $request->id)
                        ->where('organisation_id', $auth->active_organisation) 
                        ->first();
    
        if (!$client) {
            return response()->json([
                'success' => false,
                'message' => 'Client not found'
            ], 404);
        }
    
        $response = [
            'result' => $client,
            'success' => true,
            'message' => 'Client Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
    
    public function deleteClient(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $client = Client::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$client) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Client not found'
                    ], 404);
                }

                $client['is_disabled']='1';
                $client->update();

                $response=[
                    'success'=>true,
                    'message'=>'Client Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }

    public function updateStatusClient(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'id'=>'required|integer'
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $client = Client::where('id',$request->input('id'))->first();
                $client['status']=$request['status'];
                $client->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$client
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

}
