<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Service\Hrms\ExperienceService;
use App\Service\Hrms\EducationService;
use App\Service\Hrms\ContactService;
use App\Service\Hrms\DocumentService;

use App\Models\Hrms\Experience;
use App\Models\Hrms\Education;
use App\Models\Hrms\Contact;
use App\Models\Hrms\Document;
use App\Models\Hrms\Employee;
use App\Models\User;
use Hash;
use Validator;
use Auth;
use Carbon\Carbon;

class EmployeeController extends Controller
{

    public function employeeCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            // 'first_name'=>'required',
            // 'last_name'=>'required',
            'email'=>'required'
            // 'mobile_no'=>'required',
            // 'role_id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'employee_id',
                    'first_name',
                    'last_name',
                    'email',
                    'mobile_no',
                    'date_of_birth',
                    'age',
                    'marital',
                    'gender',
                    'joining_date',
                    'designation_id',
                    'department_id',
                    'reporting_manager_id',
                    'date_of_exit',
                    'experience',
                    'employment_type',
                    'employee_status',
                    'source_of_hire',
                    'referrer_id',
                    'role_id'
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['image'] = isset($request['image']) ? json_encode($request['image']) : null;

                if($request->id>0){

                    try{
                        $obj1['first_name']=$request['first_name'];
                        $obj1['last_name']=$request['last_name'];
                        $obj1['display_name']=$request['display_name'];
                        $obj1['email']=$request['email'];
                        $obj1['mobile_no']=$request['mobile_no'];
                        $obj1['is_user']=$request['is_user']??0;
                        $obj1['shift_id']=$request['shift_id']??1;

                        $obj1['user_expiry_date']=$request['user_expiry_date']??Carbon::now()->addDays(7);

                        $user=User::findOrFail($request['id']);

                        if($request['app_permission']!=null && isset($request['app_permission'])){
                            $user['app_permission']=$request['app_permission'];
                        }else{
                            $app_permission="{\"accounting\":1,\"hrms\":0,\"manufacturing\":0,\"logistics\":0,\"workshop\":0,\"cms\":0,\"tms\":0,\"legal\":0,\"mice_dsr\":0,\"travel_agency\":0}";
                            $user['app_permission']=json_decode($app_permission, true);
                        }
                        
                        $user->update($obj1);

                        $empuser=Employee::where('user_id',$request['id'])->first();
                        if($empuser!=null)
                        $empuser->update($obj);

                        Contact::where('user_id',$request['id'])->delete();
                        $contact=new ContactService;
                        $contact->contactCreateUpdate($request,$user);

                        Experience::where('user_id',$request['id'])->delete();
                        $experience=new ExperienceService;
                        $experience->experienceCreateUpdate($request,$user);

                        Education::where('user_id',$request['id'])->delete();
                        $education=new EducationService;
                        $education->educationCreateUpdate($request,$user);

                        Document::where('user_id',$request['id'])->delete();
                        $document=new DocumentService;
                        $document->documentCreateUpdate($request,$user);
                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $checkemail=User::where('email',$request['email'])->where('is_disabled',0)
                                ->where('organisation_id',$auth['active_organisation'])
                                ->first();

                    if($checkemail !=null){

                        $response=[
                            'message'=>"Email id already exist",
                            'success'=>false,
                            'vendor'=>$checkemail
                        ];

                        return response()->json($response);
                    }

                    $obj1['first_name']=$request['first_name'];
                    $obj1['last_name']=$request['last_name'];
                    $obj1['display_name']=$request['display_name'];
                    $obj1['email']=$request['email'];
                    $obj1['mobile_no']=$request['mobile_no'];
                    $obj1['shift_id']=$request['shift_id']??1;
                    $obj1['user_expiry_date']=$request['user_expiry_date']??Carbon::now()->addDays(30);

                    $user=User::create($obj1);
                    $user['is_employee'] = '1';
                    $user['is_user'] = $request['is_user']??0;

                    if($request['app_permission']!=null && isset($request['app_permission'])){
                        $user['app_permission']=$request['app_permission'];
                    }else{
                        $app_permission="{\"accounting\":1,\"hrms\":0,\"manufacturing\":0,\"logistics\":0,\"workshop\":0,\"cms\":0,\"tms\":0,\"legal\":0,\"mice_dsr\":0,\"travel_agency\":0}";
                        $user['app_permission']=json_decode($app_permission, true);
                    }

                    if(isset($request['password'])){
                        $user['password']=Hash::make($request['password']);
                        $user['c_password']=$request['password'];
                    } 

                    $user->update();

                    $empuser=Employee::create($obj);

                    $empuser['employee_id'] = "EMP-".$empuser->id;
                    $empuser['user_id'] = $user->id;
                    $empuser->update();

                    // Log::info($user);
                    $contact=new ContactService;
                    $contact->contactCreateUpdate($request,$user);

                    $experience=new ExperienceService;
                    $experience->experienceCreateUpdate($request,$user);

                    $education=new EducationService;
                    $education->educationCreateUpdate($request,$user);
                    
                    $document=new DocumentService;
                    $document->documentCreateUpdate($request,$user);
                }

                Log::info("New Employee Created =".$request);

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Employee update successfully':'Employee Created Successfully',
                    'result'=>$empuser
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


    public function getEmployee(Request $request){

        $user=Auth::user();

        if($user!=null){

            $userlist=User::where('is_disabled','0')
                ->with('employee')
                ->where('is_employee','1');
                // ->with('department:id,department_name')
                // ->with('designation:id,designation_name')
                    // ->where('organisation_id',$user['active_organisation'])

            // $userlist=$this->fetchuserbyquery($userlist,$request);

            if($request['employee_status']!='' && isset($request['employee_status'])){
                $userlist=$userlist->where('employee_status',$request['employee_status']);
            }
            $count=$userlist->count();
            
            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';

            $userlist = $userlist->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$userlist,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$userlist,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($userlist,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $userlist = $userlist->whereRaw(" (employee_id like ? or first_name like ? or email like ? or mobile_no like ? 
            or employment_type like ? or last_name like ?) ", array($keyword , $keyword , $keyword ,$keyword,$keyword,$keyword));
        }

        if($request['employee_status']!='' && isset($request['employee_status'])){
            $userlist=$userlist->where('employee_status',$request['employee_status']);
        }
        if($request['health_status']!='' && isset($request['health_status'])){
            $userlist=$userlist->where('health_status',$request['health_status']);
        }

        if($request['employment_type']!='' && isset($request['employment_type'])){
            $userlist=$userlist->where('employment_type',$request['employment_type']);
        }

        if($request['department_id']!='' && isset($request['department_id'])){
            $userlist=$userlist->where('department_id',$request['department_id']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $userlist = $userlist->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $toDate .= ($fromDate === $toDate) ? ' 23:59:59' : ' 23:59:59';

            // 'fromDate' and 'toDate'
            $userlist = $userlist->where('created_at', '>=', $fromDate)->where('created_at', '<=', $toDate);
        }

        return $userlist;
    }
 
    public function getempdetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required' //send here user_id
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        // Log::info("Get Employee Details =".$request->id);

        $employee = Employee::where('user_id', $request->id)
        ->with([
            'department:id,department_name',
            'designation:id,designation_name',
            'reportingManager:id,first_name,last_name',
            'contacts',
            'contacts.country:id,name',
            'contacts.state:id,name',
            'contacts.city:id,name',
            'experiences',
            'educations',
            'documents',
            'employeeHealth'
        ])
        // ->where('organisation_id', $auth->active_organisation)
        ->first();

        $user=User::where('id',$request->id)->first();
    
        if (!$employee) {
            return response()->json([
                'success' => false,
                'message' => 'Employee not found'
            ], 404);
        }
    
        $response = [
            'success' => true,
            'message' => 'Employee Details Retrieved Successfully.',
            'result' => $employee,
            'user'=>$user
        ];
    
        return response()->json($response);
    }
    
    public function deleteEmployee(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer' //send here user_id
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $user =  User::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$user) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Employee not found'
                    ], 404);
                }

                $empuser =  Employee::where('user_id',$user->id)->first();

                $user['is_disabled']='1';
                $user->update();

                $empuser['is_disabled']='1';
                $empuser->update();

                $response=[
                    'success'=>true,
                    'message'=>'Employee Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }

    public function updateStatusEmployee(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'employee_id'=>'required|integer' //send here user_id
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $empuser = Employee::where('user_id',$request->input('employee_id'))->first();
                $empuser['employee_status']=$request['employee_status'];
                $empuser->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$empuser
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


}
