<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use App\Models\Hrms\Experience;
use App\Models\Hrms\Education;
use App\Models\Hrms\Contact;
use App\Models\Hrms\Document;
use App\Models\Hrms\Employee;
use App\Models\Hrms\EmployeeHealth;
use App\Models\User;
use Validator;
use Auth;

class EmployeeHealthController extends Controller
{

    public function healthCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'user_id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'user_id',
                    'employee_name',
                    'department_id',
                    'gender',
                    'mobile_no',
                    'contact_name',
                    'blood_group',
                    'weight',
                    'height',
                    'allergies',
                    'chronic_condition',
                    'current_medications',
                    'last_checkup_date',
                    'next_checkup_date',
                    'checkup_result',
                    'covid_affected',
                    'covid_status',
                    'notes',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }
                
                $obj['attachment'] = isset($request['attachment']) ? json_encode($request['attachment']) : null;

                $updateHealth = Employee::where('user_id', $request['user_id'])->first();
                $updateHealth->health_status = '1';
                $updateHealth->update();

                if($request->id>0){

                    try{
                        
                        $user=EmployeeHealth::findOrFail($request['id']);
                        $user->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $checkhealth = EmployeeHealth::where('user_id', $request['user_id'])
                        ->where('is_disabled', '0')
                        ->where('organisation_id', $auth['active_organisation'])
                        ->first();

                    if ($checkhealth != null) {
                        $response = [
                            'message' => "Employee health already exist",
                            'success' => false,
                            'vendor' => $checkhealth,
                        ];
    
                        return response()->json($response);
                    }

                    $user=EmployeeHealth::create($obj);
                    // Log::info($user);

                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Employee Health update successfully':'Employee Health Created Successfully',
                    'result'=>$user
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


    public function getHealth(Request $request){

        $user=Auth::user();

        if($user!=null){

            $userlist=EmployeeHealth::where('is_disabled','0')->with('department:id,department_name,department_head')
                ->where('organisation_id',$user['active_organisation']);

            $userlist=$this->fetchuserbyquery($userlist,$request);
            $count=$userlist->count();

            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';

            $userlist = $userlist->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$userlist,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$userlist,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($userlist,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $userlist = $userlist->whereRaw(" (employee_name like ? or covid_status like ? or gender like ? or mobile_no like ? or blood_group like ? or allergies like ?) ", array($keyword , $keyword , $keyword ,$keyword,$keyword,$keyword));
        }

        if($request['covid_status']!='' && isset($request['covid_status'])){
            $userlist=$userlist->where('covid_status',$request['covid_status']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $userlist = $userlist->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $userlist = $userlist->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $userlist;
    }


    public function getHealthdetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $user = EmployeeHealth::where('id', $request->id)->with('department:id,department_name,department_head')
            ->where('organisation_id', $auth->active_organisation) 
            ->first();
    
        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'Employee Health not found'
            ], 404);
        }
    
        $response = [
            'result' => $user,
            'success' => true,
            'message' => 'Employee Health Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
    
    
    public function deleteHealth(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $user =  EmployeeHealth::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$user) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Employee Health not found'
                    ], 404);
                }

                $user['is_disabled']='1';
                $user->update();

                $updateHealth = Employee::where('user_id', $user->user_id)->first();
                $updateHealth->health_status = '0';
                $updateHealth->update();

                $response=[
                    'success'=>true,
                    'message'=>'Employee Health Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }


    public function updateStatusHealth(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'id'=>'required|integer'
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $user = EmployeeHealth::where('id',$request->input('id'))->first();
                $user['covid_status']=$request['covid_status'];
                $user->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$user
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

    
}
