<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use App\Models\Hrms\Employee;
use App\Models\Hrms\Holiday;
use App\Models\User;
use Validator;
use Auth;

class HolidayController extends Controller
{

    public function holidayCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'holiday_name'=>'required',
            'from_date'=>'required',
            'to_date'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'holiday_name','from_date','to_date','description',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                if($request->id>0){

                    try{

                        $holiday=Holiday::findOrFail($request['id']);
                        $holiday->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{
                
                    $holiday=Holiday::create($obj);
                    // Log::info($holiday);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Holiday update successfully':'Holiday Created Successfully',
                    'result'=>$holiday
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

    public function getHoliday(Request $request){

        $user=Auth::user();

        if($user!=null){

            $holidayList=Holiday::where('is_disabled','0')
                ->where('organisation_id',$user['active_organisation']);

            $holidayList=$this->fetchuserbyquery($holidayList,$request);
            $count=$holidayList->count();

            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';

            $holidayList = $holidayList->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$holidayList,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$holidayList,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($holidayList,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $holidayList = $holidayList->whereRaw(" (holiday_name like ? or description like ?) ", array($keyword , $keyword));
        }

        if($request['status']!='' && isset($request['status'])){
            $holidayList=$holidayList->where('status',$request['status']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $holidayList = $holidayList->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $holidayList = $holidayList->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $holidayList;
    }

    public function getHolidaydetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $holiday = Holiday::where('id', $request->id)
                        ->where('organisation_id', $auth->active_organisation) 
                        ->first();
    
        if (!$holiday) {
            return response()->json([
                'success' => false,
                'message' => 'Holiday not found'
            ], 404);
        }
    
        $response = [
            'result' => $holiday,
            'success' => true,
            'message' => 'Holiday Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
    
    public function deleteHoliday(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $holiday = Holiday::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$holiday) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Holiday not found'
                    ], 404);
                }

                $holiday['is_disabled']='1';
                $holiday->update();

                $response=[
                    'success'=>true,
                    'message'=>'Holiday Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }

    public function updateStatusHoliday(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'id'=>'required|integer'
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $holiday = Holiday::where('id',$request->input('id'))->first();
                $holiday['status']=$request['status'];
                $holiday->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$holiday
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

}
