<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \App\Models\Hrms\JobOpening;
use Validator;
use Auth;

class JobOpeningController extends Controller
{
    public function jobopeningCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'job_title'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'job_title','department','designation','job_location',
                    'job_status','no_of_position','employee_type','experience',
                    'skills','description'
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }

                    if($request[$value]==''){
                        $obj[$value]=null;
                    }
                }

                if($request->id>0){
                    try{
                        $job_opening=JobOpening::findOrFail($request['id']);
                        
                        $job_opening->update($obj);
                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $job_opening=JobOpening::create($obj);
                }

                return response()->json([
                    'status'=>200,
                    'message'=>$request->id>0 ? 'JobOpening update successfully':'JobOpening Created Successfully',
                    'job_opening'=>$job_opening
                ],200);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    } 

    public function getJobOpening(Request $request){

        $user=Auth::user();

        if($user!=null){

            $userlist=JobOpening::where('is_disabled','0')->with('department:id,department_name')
                ->with('designation:id,designation_name','enteredby')
                ->where('organisation_id',$user['active_organisation']);

            $userlist=$this->fetchuserbyquery($userlist,$request);
            $count=$userlist->count();
            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';
            
            $userlist = $userlist->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'job_opening'=>$userlist,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'job_opening'=>$userlist,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($userlist,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $userlist = $userlist->whereRaw(" (job_title like ? or department like ? or designation like ? or employee_type like ? 
            or skills like ?) ", array($keyword , $keyword , $keyword , $keyword , $keyword));
        }

        if($request['job_status']!='' && isset($request['job_status'])){
            $userlist=$userlist->where('job_status',$request['job_status']);
        }

        if($request['employee_type']!='' && isset($request['employee_type'])){
            $userlist=$userlist->where('employee_type',$request['employee_type']);
        }

        if($request['department']!='' && isset($request['department'])){
            $userlist=$userlist->where('department',$request['department']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $userlist = $userlist->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $userlist = $userlist->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $userlist;
    }

    public function detailsJobOpening(Request $request){

        $user=Auth::user();

        try{

            $jobOpening=JobOpening::where('id',$request['id'])->with('department:id,department_name')
                    ->with('designation:id,designation_name','enteredby')
                    ->where('organisation_id',$user['active_organisation'])
                    ->first();

            $response=[
                'success'=>true,
                'jobOpening'=>$jobOpening
            ];

            return response()->json($response);

        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }

    public function updateStatusJobOpening(Request $request){

        $user=Auth::user();

        try{
            
            $JobOpening = JobOpening::find($request['job_id']);
            if($JobOpening){

                JobOpening::where('id',$request['job_id'])
                        ->where('organisation_id',$user['active_organisation'])
                        ->update(['job_status' => $request['job_status']]);

                $response=[
                    'success'=>true,
                    'message'=>"Status update successfully",
                ];
            }else{
                $response=[
                    'success'=>true,
                    'message'=>"job not found"
                ];
            }
            
            return response()->json($response);

        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }

    public function deleteJobOpening(Request $request){

        $user=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $jobOpening =  JobOpening::where('id',$request->input('id'))
                                        ->where('organisation_id',$user['active_organisation'])
                                        ->first();

                $jobOpening['is_disabled']='1';
                $jobOpening->update();

                $response=[
                    'success'=>true,
                    'message'=>'JobOpening Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }
}
