<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Hrms\MyFiles;
use Validator;
use Auth;

class MyFileController extends Controller
{
    
    public function myfileCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'file_name'=>'required',
            'notify_all'=>'required',
            'file_type'=>'required',
            'attachment'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'user_id',
                    'user_name',
                    'file_name',
                    'attachment',
                    'deadline_date',
                    'notify_all',
                    'notify_any_others',
                    'department_id',
                    'file_type',
                    'description',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['attachment'] = isset($request['attachment']) ? json_encode($request['attachment']) : null;
                $obj['user_id'] = isset($request['user_id']) ? json_encode($request['user_id']) : null;
                $obj['notify_any_others'] = isset($request['notify_any_others']) ? json_encode($request['notify_any_others']) : null;
                $obj['department_id'] = isset($request['department_id']) ? json_encode($request['department_id']) : null;

                if($request->id>0){

                    try{
                        $myfile=MyFiles::findOrFail($request['id']);
                        $myfile->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $myfile=MyFiles::create($obj);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'File update successfully':'File Created Successfully',
                    'myfile'=>$myfile
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


    public function getMyfile(Request $request){

        $user=Auth::user();

        if($user!=null){

            $myFile=MyFiles::where('is_disabled','0')
               ->where('organisation_id',$user['active_organisation']);

            $myFile=$this->fetchuserbyquery($myFile,$request);
            $count=$myFile->count();
            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';
            

            $myFile = $myFile->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'myfile'=>$myFile,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'myfile'=>$myFile,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($myFile,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $myFile = $myFile->whereRaw(" (user_name like ? or file_name like ? or file_type like ?) ", array($keyword , $keyword , $keyword));
        }

        // get custom_date data by transaction_date
        if ($request['file_type']!='' && isset($request['file_type'])) {
            $file_type = $request->file_type;
            $myFile = $myFile->where('file_type', $file_type);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $myFile = $myFile->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $myFile = $myFile->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $myFile;
    }

    public function detailsMyfile(Request $request){

        $auth=Auth::user();

        try{

            $myfile=MyFiles::where('id',$request['id'])
                ->where('organisation_id',$auth['active_organisation'])
                ->first();

            $response=[
                'success'=>true,
                'myfile'=>$myfile
            ];

            return response()->json($response);

        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }

    public function deleteMyfile(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $myFile =  MyFiles::where('id',$request->input('id'))
                                        ->where('organisation_id',$auth['active_organisation'])
                                        ->first();

                $myFile['is_disabled']='1';
                $myFile->update();

                $response=[
                    'success'=>true,
                    'message'=>'File Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }
    
    public function myfileByuserId(Request $request){

        $auth=Auth::user();

        try{

            $myfileByuserId=MyFiles::where('user_id',$request['user_id'])->where('is_disabled','0')
                ->where('organisation_id',$auth['active_organisation'])
                ->get();

            $response=[
                'success'=>true,
                'myfileByuserId'=>$myfileByuserId
            ];

            return response()->json($response);

        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }

}
