<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use App\Models\Hrms\Employee;
use App\Models\Hrms\Project;
use App\Models\Hrms\Client;
use App\Models\User;
use Validator;
use Auth;

class ProjectController extends Controller
{

    public function projectCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'project_name'=>'required',
            'client_id'=>'required',
            'project_leader'=>'required',
            'team_id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'project_name','client_id','priority','rate','start_date','end_date',
                    'project_leader','team_id','attachments','description','status','department_id'
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['team_id'] = isset($request['team_id']) ? json_encode($request['team_id']) : null;
                $obj['attachments'] = isset($request['attachments']) ? json_encode($request['attachments']) : null;

                if($request->id>0){

                    try{

                        $project=Project::findOrFail($request['id']);
                        $project->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{
                
                    $project=Project::create($obj);
                    // Log::info($project);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Project update successfully':'Project Created Successfully',
                    'result'=>$project
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

    public function getProject(Request $request){

        $user=Auth::user();

        if($user!=null){

            $projectList=Project::where('is_disabled','0')->with('client:id,full_name')
                ->where('organisation_id',$user['active_organisation']);

            $projectList=$this->fetchuserbyquery($projectList,$request);
            $count=$projectList->count();
            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';
            
            $projectList = $projectList->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$projectList,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$projectList,
                'count'=>$count,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($projectList,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $projectList = $projectList->whereRaw(" (project_name like ? or priority like ? or status like ?) ", array($keyword , $keyword, $keyword));
        }

        if($request['status']!='' && isset($request['status'])){
            $projectList=$projectList->where('status',$request['status']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $projectList = $projectList->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $projectList = $projectList->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $projectList;
    }

    public function getProjectdetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $project = Project::where('id', $request->id)->with('client:id,full_name','enteredby')
                        ->where('organisation_id', $auth->active_organisation) 
                        ->first();
    
        if (!$project) {
            return response()->json([
                'success' => false,
                'message' => 'Project not found'
            ], 404);
        }
    
        $response = [
            'result' => $project,
            'success' => true,
            'message' => 'Project Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
    
    public function deleteProject(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $project = Project::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$project) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Project not found'
                    ], 404);
                }

                $project['is_disabled']='1';
                $project->update();

                $response=[
                    'success'=>true,
                    'message'=>'Project Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }

    public function updateStatusProject(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'id'=>'required|integer'
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $project = Project::where('id',$request->input('id'))->first();
                $project['status']=$request['status'];
                $project->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$project
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

    public function getClientProject(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'client_id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $clientProject = Project::where('is_disabled','0')->where('client_id', $request->client_id)
                        ->where('organisation_id', $auth->active_organisation) 
                        ->get();
    
        if (!$clientProject) {
            return response()->json([
                'success' => false,
                'message' => 'Project not found'
            ], 404);
        }
    
        $response = [
            'result' => $clientProject,
            'success' => true,
            'message' => 'Project Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
}
