<?php

namespace App\Http\Controllers\Api\Hrms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Hrms\Ticket;
use App\Models\User;
use App\Models\Feedback;
use App\Models\Employee;
use Auth;
use Log;
use Validator;

class TicketController extends Controller
{
    public function ticketCreateUpdate(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
            'user_id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            try{

                $data=[
                    'user_id',
                    'user_name',
                    'requested_to',
                    'priority',
                    'subject',
                    'attachment',
                    'date',
                    'description',
                    'status',
                ];
                
                foreach ($data as $key => $value) {
                    if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                        $obj[$value]=$request[$value];
                    }
                }

                $obj['attachment'] = isset($request['attachment']) ? json_encode($request['attachment']) : null;

                if($request->id>0){

                    try{
                        $ticket=Ticket::findOrFail($request['id']);
                        $ticket->update($obj);

                    } catch (\Exception $e) {
                        return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                    }
                }else{

                    $ticket=Ticket::create($obj);
                    // Log::info($ticket);
                }

                return response()->json([
                    'status'=>200,
                    'message'=> $request->id>0 ? 'Ticket update successfully':'Ticket Created Successfully',
                    'result'=>$ticket
                ],200);
                
            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }


    public function getTicket(Request $request){

        $user=Auth::user();

        if($user!=null){

            $ticketList=Ticket::where('is_disabled','0')
                ->with(['employee','requestedTo']);
                // ->where('organisation_id',$user['active_organisation']);

            $ticketList=$this->fetchuserbyquery($ticketList,$request);
            $totalCount= (Clone $ticketList)->count();
            $approvedCount= (Clone $ticketList)->where('status',1)->count();     //Approved
            $pendingCount= (Clone $ticketList)->where('status',0)->count();       // pending
            $rejectedCount= (Clone $ticketList)->where('status',2)->count();   //rejected

            $sortOrder = ($request['sortOrder'] == 1) ? 'desc' : 'asc';
            $sortBy = $request['sortBy'] ?? 'id';

            $ticketList = $ticketList->orderby($sortBy,$sortOrder)
                ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$ticketList,
                'totalCount'=>$totalCount,
                'approvedCount'=>$approvedCount,
                'pendingCount'=>$pendingCount,
                'rejectedCount'=>$rejectedCount,
                'message'=>'Successful',
            ];

        } else {
            $response=[
                'result'=>$ticketList,
                'totalCount'=>$totalCount,
                'approvedCount'=>$approvedCount,
                'pendingCount'=>$pendingCount,
                'rejectedCount'=>$rejectedCount,
                'message'=>'Invalid User'
            ];
        }

        return response()->json($response);
    }
    
    // Filter Users
    public function fetchuserbyquery($ticketList,$request){

        if(isset($request['search']) && $request['search']!='') {
            $keyword = "%".$request['search']."%";
            $ticketList = $ticketList->whereRaw(" (priority like ? or subject like ? or date like ? or user_name like ?) ", array($keyword , $keyword , $keyword , $keyword));
        }

        if($request['status']!='' && isset($request['status'])){
            $ticketList=$ticketList->where('status',$request['status']);
        }

        // get custom_date data by transaction_date
        if ($request['custom_date']!='' && isset($request['custom_date'])) {
            $customDate = $request->custom_date;
            $ticketList = $ticketList->whereDate('created_at', $customDate);
        }

        // get fromDate toDate data by created_at
        if ($request['fromDate']!='' && isset($request['toDate'])) {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        
            // 'fromDate' and 'toDate'
            $ticketList = $ticketList->whereBetween('created_at', [$fromDate, $toDate]);
        }

        return $ticketList;
    }

    public function getTicketdetails(Request $request) {
        $response = [];
        $auth = Auth::user();
        
        // Validate Input
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }
    
        $ticket = Ticket::where('id', $request->id)
                    ->with(['employee','requestedTo','enteredby'])
                        // ->where('organisation_id', $auth->active_organisation) 
                        ->first();
    
        if (!$ticket) {
            return response()->json([
                'success' => false,
                'message' => 'Ticket not found'
            ], 404);
        }
    
        $response = [
            'result' => $ticket,
            'success' => true,
            'message' => 'Ticket Details Retrieved Successfully.'
        ];
    
        return response()->json($response);
    }
    
    public function deleteTicket(Request $request){

        $auth=Auth::user();

        $validator=validator($request->all(),[
           'id'=>'required|integer'
        ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{
                $ticket =  Ticket::where('id',$request->input('id'))
                            ->where('organisation_id',$auth['active_organisation'])
                            ->first();

                if (!$ticket) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Ticket not found'
                    ], 404);
                }

                $ticket['is_disabled']='1';
                $ticket->update();

                $response=[
                    'success'=>true,
                    'message'=>'Ticket Deleted successfully.'
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
       }
    }

    public function updateStatusTicket(Request $request){

        $auth=Auth::user();
        
        $validator=validator($request->all(),[
            'id'=>'required|integer'
         ]);
 
        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            try{
                
                $ticket = Ticket::where('id',$request->input('id'))->first();
                $ticket['status']=$request['status'];
                $ticket->update();

                $response=[
                    'success'=>true,
                    'message'=>'Status Updated successfully.',
                    'result'=>$ticket
                ];

                return response()->json($response);

            } catch (\Exception $e) {
                return response(['error' => true, 'message' => $e->getMessage()], 404); 
            }
        }
    }

}

