<?php

namespace App\Http\Controllers\Api\Manufacturing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Auth;
use App\Models\Machinery;
use App\Models\MachineMaintenance;
use App\Models\MachineryOperation;
use App\Models\ProductionOperation;
use App\Service\SequenceService;
use Carbon\Carbon;

class MachineryController extends Controller
{
    public function index(Request $request)
    {
        $query = Machinery::with('workstation:id,name','entry_by:id,name')
            ->where('rolledback',0);

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function($q) use ($search) {

                $q->where('machine_name', 'like', '%' . $search . '%')

                  ->orWhere('machine_id', $search)

                  ->orWhere('model_number', 'like', '%' . $search . '%')

                  ->orWhere('manufacturer', 'like', '%' . $search . '%')

                  ->orWhere('status', 'like', '%' . $search . '%');

                //   ->orWhereHas('workstation', function ($query) use ($request) {
                //     $query->where('name', 'LIKE', '%' . $request['search'] . '%');
                // });

            });
        }

        if ($request->has('status')) {
            $status = $request->input('status');
            $query->where('status', $status);
        }

        if ($request->has('is_active')) {
            $is_active = $request->input('is_active');
            $query->where('is_active', $is_active);
        }

        if ($request->has('availability_status')) {
            $availability_status = $request->input('availability_status');
            $query->where('availability_status', $availability_status);
        }

        if ($request->has('workstation_id')) {
            $workstation_id = $request->input('workstation_id');
            $query->where('machinery.workstation_id', $workstation_id);
        }

        $count=$query->count();

        // Sorting 
        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $query = $query->orderby($request['sort_by'],$sort_order);

        }else{
            $query = $query->orderby('id','desc');
        }
        
        $machinery=$query->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        return $response=[
            'success'=>true,
            'total'=>$count,
            'machinery'=>$machinery,
            'message'=>'All Machinery Listed Successfully'
        ];
    
    }

    // Store a newly created machinery item
    public function store(Request $request)
    {
        $obj['machine_name'] = $request['machine_name'];
        $obj['machine_id'] = $request['machine_id'];
        $obj['model_number'] = $request['model_number'] ;
        $obj['manufacturer'] = $request['manufacturer'] ;
        $obj['purchase_date'] = $request['purchase_date'] ;
        $obj['running_time'] = $request['running_time'] ;
        $obj['start_time'] = $request['start_time'] ;
        $obj['end_time'] = $request['end_time'] ;
        $obj['operation_id'] = $request['operation_id'];
        $obj['status'] = $request['status'] ;
        $obj['workstation_id'] = $request['workstation_id']??0;
        $obj['notes'] = $request['notes'];
        $obj['attachment'] = $request['attachment'] ;

        $machinery=Machinery::create($obj);

        $module='machinery';

        if(isset($request['operations'])){
            foreach ($request['operations'] as $key => $value) {
                $ob['operation_id']=$value['operation_id']??0;
                $ob['operation_name']=$value['operation_name'];
                $ob['start_time']=$value['start_time'];
                $ob['end_time']=$value['end_time'];
                $ob['machinery_id']=$machinery['id'];

                $operation=MachineryOperation::create($ob);
            }
        }
        // Update Sequence
        $sequence=new SequenceService;
        $sequence->updateSequence($module);

        return response()->json(['success'=>true,'message' => 'Machinery created successfully','machinery'=>$machinery],200);
    }
    
    // Store a newly created machinery item
    public function record_maintenance(Request $request)
    {

        $obj['machine_id'] = $request['machine_id'] ;
        $obj['date_time'] = $request['date_time'] ;
        $obj['done_by'] = $request['done_by'] ;
        $obj['remarks'] = $request['remarks'] ; 
        $obj['attachment'] =$request['attachment'] ;

        $maintenance=MachineMaintenance::create($obj);

        return response()->json(['success'=>true,'message' => 'Maintenance recorded successfully','machine_manitenance'=>$maintenance], 201);
    }

    // Display the specified machinery item
    public function show(Request $request)
    {

        $today=Carbon::today()->format('Y-m-d');

        $machine = Machinery::with('workstation','entry_by:id,name','machine_maintenance','operations')
                        ->where('id',$request['id'])
                        ->first();
                     
        // $machine_maintenance= MachineMaintenance::where('machine_id', $id)->get();

        if (!$machine) {
            return response()->json(['success'=>false,'message' => 'Machinery item not found'], 404);
        }

        $operation = ProductionOperation::with('machinery')->where('machinery_id', $request['id'])
            ->whereHas('production',function($query) use ($today){
                $query->where('date_time',$today);
            })->get();
        
        return $response = [
             'success' => true,
             'message' => 'Machine detail fetched Successfully',
             'machine' => $machine,
             'operations'=>$operation
            //  'machine_maintenance' => $machine_maintenance
        ];

        return response()->json($machine);
    }

    // Update the specified machinery item
    public function update(Request $request)
    {
        $validator=validator($request->all(),[
            'id'=>'required|integer',
        ]);
 
        if ($validator->fails()) { 
 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
 
        } else {

            $obj['machine_name'] = $request['machine_name'];
            $obj['machine_id'] = $request['machine_id'];
            $obj['model_number'] = $request['model_number'] ;
            $obj['manufacturer'] = $request['manufacturer'] ;
            $obj['purchase_date'] = $request['purchase_date'] ;
            $obj['running_time'] = $request['running_time'] ;
            $obj['start_time'] = $request['start_time'] ;
            $obj['end_time'] = $request['end_time'] ;
            $obj['operation_id'] = $request['operation_id'] ??0;
            $obj['status'] = $request['status'] ;
            $obj['workstation_id'] = $request['workstation_id']??0 ;
            $obj['notes'] = $request['notes'];
            $obj['attachment'] = $request['attachment'] ;

            try{
                $machine=Machinery::findOrFail($request['id']);
                $machine->update($obj);

                $operations=MachineryOperation::where('machinery_id',$machine['id'])->delete();

                if(isset($request['operations'])){
                    foreach ($request['operations'] as $key => $value) {
                        $ob['operation_id']=$value['operation_id'];
                        $ob['operation_name']=$value['operation_name'];
                        $ob['start_time']=$value['start_time'];
                        $ob['end_time']=$value['end_time'];
                        $ob['machinery_id']=$machine['id'];
        
                        MachineryOperation::create($ob);
                    }
                }

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 404);
            }

            return response()->json(['success'=>true,'message' => 'Machinery item updated successfully','machinery'=>$machine]);
        }
    }

    // Delete a workstation (soft delete by setting status to 0)
    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
                                                                                                    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 400);
        }
        Machinery::where('id', $request['id'])->update(['rolledback' => 1]);

        return response()->json(['success'=>true,'message' => 'Machinery deleted successfully','success'=>true]);
    }

     // Update status Active and In Active
    public function status(Request $request){

        // Validate Item

        $validator=validator($request->all(),[
            'machinery_id'=>'required|integer'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

        try{

            $machinery =  Machinery::findOrFail($request['machinery_id']);

            if(isset($request['is_active'])){
                    $machinery['is_active']=$request['is_active'];
            }

            if(isset($request['status'])){
                    $machinery['status']=$request['status'];
            }

            $machinery->update();

            $response=[
                'success'=>true,
                'message'=>'Machinery Status Updated successfully.'
            ];

        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

            // Return error message in JSON if ID not found
            return response()->json(['success'=>false,'message' => 'Invalid Id found'], 404);
        }

        return response()->json($response);

        }

    }

    // Get all operations
    // Fetch all active Production Operations for a Machinery
    public function activeMachineOperations(Request $request)
    {
        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $currentTime = now(); // current datetime

            $production_operation = ProductionOperation::where('machinery_id', $request['id'])
                ->where('start_datetime', '<=', $currentTime)
                ->where('end_datetime', '>=', $currentTime)
                ->with('production', 'operations', 'workstation');

            $count = $production_operation->count();

            $production_operation = $production_operation->orderBy('id', 'desc')
                ->skip($request['noofrec'] * ($request['currentpage'] - 1))->ta+
                ke($request['noofrec'] ?? 100)
                ->get();

            return response()->json([
                'success' => true,
                'total' => $count,
                'production_operations' => $production_operation,
                'message' => 'Active production operations fetched successfully'
            ]);
        }
    }
}
