<?php

namespace App\Http\Controllers\Api\Manufacturing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Service\ActivityService;
use Auth;
use App\Models\Store;
use App\Models\Item;
use App\Models\ManufacturingStore;

class StoreController extends Controller
{
    public function createUpdate(Request $request){
        // Validate Name
        $validator=validator($request->all(),[
            'name'=>'required|string'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {  
            $obj['name']=ucwords($request['name']);
            $obj['branch_name']=$request['branch_name'];
            $obj['capacity']=$request['capacity'];
            $obj['department']=$request['department'];
            $obj['store_for']=$request['store_for'];
            $obj['branch_name']=$request['branch_name'];
            $obj['address']=$request['address'];
            $obj['city_id']=$request['city']??0;
            $obj['country_id']=$request['country']??0;
            $obj['state_id']=$request['state']??0;
            $obj['description']=$request['description'];

            if($request['id']>0){

               try{
                   
                   $store=Store::findOrFail($request['id']);
                   $store->update($obj);

                   // Creating Activities
                   $activity=new ActivityService;
                   $activity->activityCreateUpdate('Store',$store['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }
            }else{
                $store=Store::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Store',$store['id'],'Created');
            }
           
            $response=[
                'success'=>true,
                'data'=>$store,
                'message'=>($request['id'] > 0) ? "Store Updated Successfully" : "Store Created Successfully",
            ];

           return response()->json($response);
        }
    }

    public function list(Request $request)  
    {
        $user=Auth::user();

        $store= Store::with('country:id,name','state:id,name','city:id,name');
        // ->where('organisation_id',$user['active_organisation'])

        if($request['search']!='' && isset($request['search']) && $request['search']!=null){
            $store = $store->where(function ($query) use ($request) {

                $query->where('name', 'LIKE', '%' . $request['search'] . '%');
            });
        }

        if($request['is_active']!='' && isset($request['is_active']) && $request['is_active']!=null){
            $store = $store->where('is_active',$request['is_active']);
        }

        if($request['id']!=0 && isset($request['id']) && $request['id']!=null){
            $store = $store->where('id',$request['id']);
        }

        if($request['department']!='' && isset($request['department']) && $request['department']!=null){
            // Decode the JSON string into an array
            $decodedValues = json_decode($request['department'], true);
            $store = $store->whereJsonContains('department',$decodedValues);
        }
        
        $count=$store->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $store = $store->orderby($request['sort_by'],$sort_order);

        }else{
            $store = $store->orderby('id','desc');
        }


        $store=$store->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
            // ->orderBy('id','desc')
            ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'store'=>$store,
            'message'=>'Store List Fetch Successfully'
        ];

        return response()->json($response, 200);
    }

    public function details(Request $request){

        $user=Auth::user();

         // Validate Name
         $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {  
            $store = Store::where('id',$request['id'])
                ->with('country:id,name','state:id,name','city:id,name')
                ->first();

            $response=[
                'success'=>true,
                'data'=>$store,
            ];

            return response()->json($response);
        }
    }

    public function status(Request $request){

        // Validate Item

        $validator=validator($request->all(),[

            'store_id'=>'required|integer',

            'is_active'=>'required|integer'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first(),

            ];

        } else {

            try{

                $store =  Store::where('id',$request->input('store_id'))->first();

                $store['is_active']=$request['is_active'];

                $store->update();

                $response=[

                    'success'=>true,

                    'message'=>'Status Updated successfully.',

                    'data'=>$store

                ];

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id found'], 404);

            }

            return response()->json($response);

        }

    }

    // Get All Stores Stocks 
    public function stockTransactionStore(Request $request){

        // Validate Item
        $validator=validator($request->all(),[
            'store_id'=>'required|integer'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $transaction_store=ManufacturingStore::where('store_id',$request['store_id'])
                ->with('store:id,name','item');

            if(isset($request['search']) && $request['search']!='' && $request['search']!=null){
                $transaction_store = $transaction_store->where(function ($query) use ($request) {
                    $query->whereHas('item', function ($q) use ($request) {
                        $q->where('name', 'LIKE', '%' . $request['search'] . '%');
                    });
                });
            }

            $count=$transaction_store->count();

            if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                    
                $sort_order=$request['sort_order']==1?'asc':'desc';

                $transaction_store = $transaction_store->orderby($request['sort_by'],$sort_order);

            }else{
                $transaction_store = $transaction_store->orderby('id','desc');
            }


            $transaction_store=$transaction_store->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

            $response=[
                'success'=>true,
                'count'=>$count,
                'data'=>$transaction_store,
                'message'=>'Stock Transaction Store List Fetch Successfully'
            ];

            return response()->json($response, 200);
        }
    }
}
