<?php

namespace App\Http\Controllers\Api\MiceServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Mice;
use App\Models\MicePassenger;
use App\Models\MiceSupplierSummary;
use App\Service\SequenceService;
use App\Service\ActivityService;
use App\Jobs\Naksha\MiceAccounts;
use App\Models\MiceServiceHotel;
use App\Models\MiceServiceFlight;
use App\Models\MiceServiceVisa;
use App\Models\MiceServiceCarHire;
use App\Models\MiceServiceAssist;
use App\Models\MiceServiceInsurance;
use App\Models\MiceServiceOther;
use App\Models\MiceServiceTour;
use App\Models\User;
use Auth;
use Log;
use Carbon\Carbon;

class MiceController extends Controller
{
    // Create a new DSR entry
    public function miceCreateUpdate(Request $request)
    {
        // Validate the input
        $validator=validator($request->all(),[
            'customer_id' => 'required|integer',
            'customer_name' => 'nullable|string|max:100',
            'currency' => 'nullable|string|max:20',
            'mice_no' => 'nullable|string|max:50',
            // 'exchange_rate' => 'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            // Activity Service
            $activity=new ActivityService;
            $sequence=new SequenceService;

            $obj['customer_id']=$request['customer_id'];
            $obj['customer_name']=$request['customer_name'];
            $obj['currency']=$request['currency'];
            $obj['currency_symbol']=$request['currency_symbol'];
            $obj['exchange_rate']=$request['exchange_rate']??0.00;
            $obj['mice_no']=$request['mice_no'];
            $obj['mice_name']=$request['mice_name'];
            $obj['transaction_date']=Carbon::now()->format('Y-m-d');
            $obj['description']=$request['description'];
            $obj['destination']=$request['destination'];
            $obj['address']=$request['address'];
            
            if($request['id']>0){

                try{

                    $dsr=Mice::findOrFail($request['id']);
                    $dsr->update($obj);

                    //Creating Activities 
                    $activity->activityCreateUpdate('MICE Service',$dsr['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 200);
                }

            }else{
                // Create the Mice
                $dsr = Mice::create($obj);

                //Creating Activities 
                $activity->activityCreateUpdate('MICE Service',$dsr['id'],'Created');

                // Update Sequence Number
                $sequence->updateSequence('mice');
            }
            
            $response=[
                'success' => true,
                'message' => $request['id']>0?'Mice Updated Successfully':'Mice created successfully',
                'data' => $dsr
            ];

            return response()->json($response);

        }
     }
 
    //  DSR Lists
    public function miceList(Request $request){

        $dsr=Mice::where('rolledback',0)->with('customer');

        if($request['search']!=null && $request['search']!=""){
            $dsr=$dsr->where('customer_name','like','%'.$request['search'].'%')
                ->orWhere('mice_no','like','%'.$request['search'].'%');
        }

        $count=$dsr->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $dsr = $dsr->orderby($request['sort_by'],$sort_order);

        }else{
            $dsr = $dsr->orderby('id','desc');
        }
        
        $dsr=$dsr->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$dsr,
            'message'=>'All Mice Listed Successfully'
        ];
        
        return response()->json($response);

            
    }

    //  Mice Details
    public function miceDetails(Request $request){
          // Validate the input
          $validator=validator($request->all(),[
            'mice_id' => 'required|integer'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $dsr=Mice::where('id',$request['mice_id'])
                ->where('rolledback',0)->with('customer','passengers','passengers.passenger')
                ->first();

            if (isset($dsr['passengers']) && !empty($dsr['passengers'])) {

                foreach ($dsr['passengers'] as $key => $passenger) {

                    $dsr_passenger=MicePassenger::where('id',$passenger['id'])
                        ->with('passenger:id,email,display_name','mice:id,mice_no')
                        ->first();

                    if ($dsr_passenger) {

                        $dsrServiceHotel = MiceServiceHotel::where('passenger_id', $passenger['id'])
                            ->with('room:id,room_number')
                            ->where('is_cancle',0)
                            ->get();

                        foreach ($dsrServiceHotel as $index => $hotel) {
                            $guestIds = explode(',', $hotel['guest_ids'] ?? '');
                            $hotel['guests']=User::whereIn('id',$guestIds)->get();
                        }
                        // Attach hotels to the passenger entry
                        $dsr['passengers'][$key]['hotels'] = $dsrServiceHotel;

                        $dsrServicFlight = MiceServiceFlight::where('passenger_id', $passenger['id'])
                            ->where('is_cancle',0)
                            // ->with()
                            ->get();

                        foreach ($dsrServicFlight as $index => $flight) {
                            $guestIds = explode(',', $flight['guest_ids'] ?? '');
                            $flight['guests']=User::whereIn('id',$guestIds)->get();
                        }
                        // Attach Flights to the passenger entry
                        $dsr['passengers'][$key]['flights'] = $dsrServicFlight;

                        $dsrServicVisa = MiceServiceVisa::where('passenger_id', $passenger['id'])
                            ->where('is_cancle',0)
                            ->with('visa_passenger:id,display_name')
                            ->get();

                        foreach ($dsrServicVisa as $index => $visa) {
                            $guestIds = explode(',', $visa['guest_ids'] ?? '');
                            $visa['guests']=User::whereIn('id',$guestIds)->get();
                        }
                        // Attach Visas to the passenger entry
                        $dsr['passengers'][$key]['visas'] = $dsrServicVisa;

                        $dsrServicAssist = MiceServiceAssist::where('passenger_id', $passenger['id'])
                            ->where('is_cancle',0)
                            // ->with('visa_passenger:id,display_name','country:id,name')
                            ->get();

                        foreach ($dsrServicAssist as $index => $assist) {
                            $guestIds = explode(',', $assist['guest_ids'] ?? '');
                            $assist['guests']=User::whereIn('id',$guestIds)->get();
                        }
                        // Attach Assists to the passenger entry
                        $dsr['passengers'][$key]['assists'] = $dsrServicAssist;

                        $dsrServicCarHire = MiceServiceCarHire::where('passenger_id',$passenger['id'])
                            ->where('is_cancle',0)
                            // ->with('visa_passenger:id,display_name','country:id,name')
                            ->get();

                        foreach ($dsrServicCarHire as $index => $car_hire) {
                            $guestIds = explode(',', $car_hire['guest_ids'] ?? '');
                            $car_hire['guests']=User::whereIn('id',$guestIds)->get();
                        }
                        // Attach Car hire to the passenger entry
                        $dsr['passengers'][$key]['car_hires'] = $dsrServicCarHire;

                        $dsrServicInsurance = MiceServiceInsurance::where('passenger_id', $passenger['id'])
                            ->where('is_cancle',0)
                            ->with('passenger')
                            ->get();
                        // Attach Insurance to the passenger entry
                        $dsr['passengers'][$key]['insurance'] = $dsrServicInsurance;

                        $dsrServicOthers = MiceServiceOther::where('passenger_id', $passenger['id'])
                            ->where('is_cancle',0)
                            // ->with('visa_passenger:id,display_name','country:id,name')
                            ->get();
                        // Attach Insurance to the passenger entry
                        $dsr['passengers'][$key]['others'] = $dsrServicOthers;

                        // Show tour Package Details
                        $dsrServicTour = MiceServiceTour::where('passenger_id',$passenger['id'])
                            ->where('is_cancle',0)
                            ->with('tour_package','tour_package.itinerary','tour_package.itinerary.itinary_rows',
                            'tour_package.itinerary.itinary_rows.accomodation','tour_package.itinerary.itinary_rows.transport',
                            'tour_package.itinerary.itinary_rows.destination')
                            // ->with('visa_passenger:id,display_name','country:id,name')
                            ->get();

                        foreach ($dsrServicTour as $index => $tour) {
                            $guestIds = explode(',', $tour['guest_ids'] ?? '');
                            $tour['guests']=User::whereIn('id',$guestIds)->get();
                        }
                        // Attach Car hire to the passenger entry
                        $dsr['passengers'][$key]['tour_packages'] = $dsrServicTour;
                    }
                }

            }

            $response=[
                'success'=>true,
                'data'=>$dsr,
                'message'=>'Mice Details Successfully'
            ];
            
            return response()->json($response);
        }

            
    }
    //  DSR Delete
    public function miceDelete(Request $request){
          // Validate the input
          $validator=validator($request->all(),[
            'mice_id' => 'required|integer'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{

                $dsr=Mice::findOrFail($request['mice_id']);
                $dsr->rolledback=1;
                $dsr->save();

                $response=[
                    'success'=>true,
                    'data'=>$dsr,
                    'message'=>'Mice Deleted Successfully'
                ];
                
                return response()->json($response);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 200);
            }

        }
            
    }
    //  Mice Invoiced
    public function miceInvoiced(Request $request){
          // Validate the input
          $validator=validator($request->all(),[
            'mice_id' => 'required|integer'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{

                $mice=Mice::findOrFail($request['mice_id']);

                if($mice['is_invoiced']==0){

                    // Dispatch the job to send data to accounts table
                    MiceAccounts::dispatch($mice);

                    $mice->is_invoiced=1;
                    // $mice->transaction_date=Carbon::now()->format('Y-m-d');
                    $mice->save();
    
                    $response=[
                        'success'=>true,
                        'data'=>$mice,
                        'message'=>'Mice Invoiced Successfully'
                    ];

                }else{

                    $response=[
                        'success'=>false,
                        'message'=>'Mice Invoiced already made',
                        'data'=>$mice
                    ];
                }
                
                return response()->json($response);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 200);
            }

        }
            
    }


    // Mice Passengers Create
    public function micePassengerCreate(Request $request){
          // Validate the input
          $validator=validator($request->all(),[
            'mice_id' => 'required|integer',
            'customer_id' => 'required|integer',
            'passenger_name' => 'nullable|string|max:100'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['mice_id']=$request['mice_id'];
            $obj['customer_id']=$request['customer_id'];
            $obj['passenger_name']=$request['passenger_name'];
            
            if($request['id']>0){

                $dsr=MicePassenger::findOrFail($request['id']);
                $dsr->update($obj);

            }else{
                // Create the DSR
                $dsr = MicePassenger::create($obj);
            }
            
            $response=[
                'success' => true,
                'message' => $request['id']>0?'Passenger Updated Successfully':'Passenger created successfully'
            ];

            return response()->json($response);
        }
    }
    //Mice Passenger Delete
    public function micePassengerDelete(Request $request){
         // Validate the input
         $validator=validator($request->all(),[
            'passenger_id' => 'required|integer',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            
            try {
                    
                $mice=MicePassenger::findOrFail($request['passenger_id']);

                //update all the services for this passenger
                // All Services Lists
                $services=['Hotel','Flight','Visa','Assist','CarHire','Insurance','Other','Tour'];

                // Calling all the services in a loop
                foreach ($services as $key => $service) {

                    $namespace = 'App\Models';                            // Replace with the actual namespace
                    $miceService = $namespace . '\MiceService' . $service;  //'App/Models/MiceServiceAssist'

                    // Getting all the data of single service like Assists, all Assists in a passenger
                    $mice_service=$miceService::where('mice_id',$mice['mice_id'])
                        ->where('passenger_id',$mice['id'])
                        ->where('is_cancle',0)
                        ->update(['is_cancle'=>1]);
                }

                $mice['rolledback']=1;
                $mice->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to Delete '], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'Passenger Deleted Successfully',
            ];
    
            return response()->json($response);
        }
    }

     // Get all supplier entry Mice 
     public function getSupplierSummaryMice(Request $request){

        $validator=validator($request->all(),[
            'mice_id' => 'required|integer',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            
            $summary=MiceSupplierSummary::where('mice_id',$request['mice_id'])
                ->with('mice:mice_no,transaction_date,id');
            
            if(isset($request['supplier_name']) && $request['supplier_name']!=''){
                $summary=$summary->where('supplier_name','like','%'.$request['supplier_name'].'%');
            }

            if($request['search']!=null && $request['search']!=""){
                $summary=$summary->where('supplier_name','like','%'.$request['search'].'%')
                    ->orWhere('service_name','like','%'.$request['search'].'%')
                    ->orWhere('tax_percent',$request['search']);
            }
             
            $summary=$summary->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                ->get();

            $response=[
                'success'=>true,
                'message'=>'Suppliers listed Successfully',
                'data'=>$summary
            ];

            return response()->json($response);
        }

    }

     // Get all supplier entry in DSRs
    public function getAllSupplierSummary(Request $request){
            
        $summary=MiceSupplierSummary::with('mice:mice_no,transaction_date,id,currency_symbol,exchange_rate,currency,is_invoiced');
        
        if(isset($request['supplier_name']) && $request['supplier_name']!=''){
            $summary=$summary->where('supplier_name','like','%'.$request['supplier_name'].'%');
        }
        if(isset($request['supplier_id']) && $request['supplier_id']!=0){
            $summary=$summary->where('supplier_id',$request['supplier_id']);
        }
        // For Billed 
        if(isset($request['is_billed']) && $request['is_billed']==1){
            $summary=$summary->where('is_billed',$request['is_billed']);
        }
        // For Un billed
        if(isset($request['is_billed']) && $request['is_billed']==2){
            $summary=$summary->where('is_billed',0);
        }

        if(isset($request['service_name']) && $request['service_name']!=''){
            $summary=$summary->where('service_name','like','%'.$request['service_name'].'%');
        }

        $total=$summary->count();
            
        $summary=$summary->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->orderBy('id','desc')
            ->get();

        $response=[
            'success'=>true,
            'message'=>'All Suppliers Summary listed Successfully',
            'total'=>$total,
            'data'=>$summary
        ];

        return response()->json($response);

    }
}
