<?php

namespace App\Http\Controllers\Api\MiceServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MiceServiceHotel;
use App\Models\MiceServiceFlight;
use App\Models\MiceServiceVisa;
use App\Models\MiceServiceCarHire;
use App\Models\MiceServiceAssist;
use App\Models\MiceServiceInsurance;
use App\Models\MiceServiceOther;
use App\Models\MiceServiceTour;
use App\Models\User;
use App\Models\MicePassenger;
use App\Models\MiceSupplierSummary;
use App\Service\ActivityService;
use App\Service\DsrMiceService\SupplierSummary;

class MicePassengerServiceController extends Controller
{
    // Mice Service Hotel Create
    public function miceHotelCreateUpdate(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_id' => 'nullable|integer',
            'hotel_id' => 'nullable|integer',
            'hotel_name' => 'nullable|string',
            'room_id' => 'nullable|integer',
            'meal_id' => 'nullable|integer',
            'bed' => 'nullable|integer',
            'guest_ids' => 'nullable|string',
            'booking_date' => 'nullable|date',
            'check_in_date' => 'nullable|date',
            'check_out_date' => 'nullable|date',
            'gross_amount' => 'nullable|numeric',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;

            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];
            $obj['hotel_id'] = $request['hotel_id'];
            $obj['hotel_name'] = $request['hotel_name'];
            $obj['room_id'] = $request['room_id'];
            $obj['room_number'] = $request['room_number'];
            $obj['meal_id'] = $request['meal_id'];
            $obj['bed'] = $request['bed'];
            $obj['guest_ids'] = $request['guest_ids'];
            $obj['booking_date'] = $request['booking_date'];
            $obj['check_in_date'] = $request['check_in_date'];
            $obj['check_out_date'] = $request['check_out_date'];
            $obj['supplier_id'] = $request['supplier_id'];
            $obj['supplier_name'] = $request['supplier_name'];
            $obj['total_nights'] = $request['total_nights'];
            $obj['gross_amount'] = $request['gross_amount'];
            $obj['tax_percent'] = $request['tax_percent'];
            $obj['tax_amount'] = $request['tax_amount'];
            $obj['supplier_total'] = $request['supplier_total'];
            $obj['retain'] = $request['retain'];
            $obj['total_amount'] = $request['total_amount'];
            $obj['upload_image'] = $request['upload_image'];
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount'];
            $obj['charges'] = $request['charges'];
            $obj['confirmation_no'] = $request['confirmation_no'];
            $obj['occupancy_id'] = $request['occupancy_id'];
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;
            $obj['booking_confirmation_no'] = $request['booking_confirmation_no']??null;

            if ($request['id'] > 0) {
                $hotel = MiceServiceHotel::findOrFail($request['id']);

                // Reverse The Amount
                $mice_passenger=MicePassenger::where('id',$hotel['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($hotel['total_amount'])??0);
                $mice_passenger->update(); 

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0.0);
                $mice_passenger->update();

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $hotel['mice_id'])
                    ->where('transaction_id', $hotel['id'])
                    ->where('service_name', 'hotel')
                    ->delete();

                $hotel->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Hotel', $hotel['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $hotel = MiceServiceHotel::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0.0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Hotel', $hotel['id'], 'Created');
            }

             // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$hotel,'hotel');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Hotel Updated Successfully' : 'MICE Service Hotel Created Successfully',
                'data' => $hotel
            ];

            return response()->json($response);
        }
    }
     // Cancel a MICE Service Hotel entry
    public function miceHotelCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_hotel_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {

            $hotel = MiceServiceHotel::findOrFail($request['mice_hotel_id']);
            $hotel->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$hotel['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($hotel['total_amount'])??0);
            $mice_passenger->update(); 

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $hotel['mice_id'])
                ->where('transaction_id', $hotel['id'])
                ->where('service_name', 'hotel')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Hotel', $hotel['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Hotel Cancelled Successfully',
                'data' => $hotel
            ]);
        }      
    }

    // MICE Service Flight Create
    public function miceFlightCreateUpdate(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_id' => 'nullable|integer',
            'travel_date' => 'nullable',
            'airline_name' => 'nullable|string|max:50',
            'guest_ids' => 'nullable|string',
            'travel_type_id' => 'nullable|integer',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;

            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];

            $obj['travel_date'] = $request['travel_date'];
            $obj['travel_type_id'] = $request['travel_type_id']??0;
            $obj['airline_name'] = $request['airline_name'];
            $obj['guest_ids'] = $request['guest_ids'];
            $obj['gds_portal'] = $request['gds_portal'];
            $obj['ticket_no'] = $request['ticket_no'];
            $obj['prn_no'] = $request['prn_no'];
            $obj['route'] = $request['route'];
            $obj['air_line_code'] = $request['air_line_code'];
            $obj['airline_digitcode'] = $request['airline_digitcode']??0;
            $obj['booking_date'] = $request['booking_date'];
            $obj['destination_code'] = $request['destination_code']??0;    //from the user masters

            $obj['from_date'] = $request['from_date']??null;
            $obj['to_date'] = $request['to_date']??null;
            $obj['booking_date'] = $request['booking_date']??null;
            $obj['booking_reference'] = $request['booking_reference']??null;
            $obj['agent_office_id'] = $request['agent_office_id']??null;
            $obj['flight_segment'] = $request['flight_segment']??null;

            $obj['supplier_id'] = $request['supplier_id'];
            $obj['supplier_name'] = $request['supplier_name'];

            $obj['gross_amount'] = $request['gross_amount']??0;      //fare amount or flight amount
            $obj['charges'] = $request['charges'];
            $obj['tax_percent'] = $request['tax_percent'];
            $obj['tax_amount'] = $request['tax_amount'];
            $obj['supplier_total'] = $request['supplier_total'];
            $obj['total_amount'] = $request['total_amount'];
            $obj['retain'] = $request['retain'];
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;

            $obj['upload_image'] = $request['upload_image'];
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount'];

            if ($request['id'] > 0) {
                $flight = MiceServiceFlight::findOrFail($request['id']);

                // Reverse the amount
                $mice_passenger=MicePassenger::where('id',$flight['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) -((float)($flight['total_amount'])??0);
                $mice_passenger->update(); 

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $flight['mice_id'])
                    ->where('transaction_id', $flight['id'])
                    ->where('service_name', 'flight')
                    ->delete();
                
                $flight->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Flight', $flight['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $flight = MiceServiceFlight::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Flight', $flight['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$flight,'flight');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Flight Updated Successfully' : 'MICE Service Flight Created Successfully',
                'data' => $flight
            ];

            return response()->json($response);
        }
    }
     // Cancel a MICE Service Flight entry
    public function miceFlightCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_flight_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {

            $flight = MiceServiceFlight::findOrFail($request['mice_flight_id']);
            $flight->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$flight['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) -((float)($flight['total_amount'])??0);
            $mice_passenger->update(); 

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $flight['mice_id'])
                ->where('transaction_id', $flight['id'])
                ->where('service_name', 'flight')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Flight', $flight['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Flight Cancelled Successfully',
                'data' => $flight
            ]);
        }      
    }

    public function miceFlightList(Request $request){
        $mice_flights = MiceServiceFlight::where('is_cancle',0)
            ->with('mice')
            ->where('flight_segment','!=',null);
        
        if($request['custom_date']!=null && isset($request['custom_date']) && $request['custom_date']!=""){
            $mice_flights = $mice_flights->where('booking_date','=',$request['custom_date']);
        }

        if (!empty($request['from_date'])) {
            $from_date = date('Y-m-d', strtotime($request['from_date']));

            if (!empty($request['to_date'])) {
                // include the full to_date (end of day)
                $to_date = date('Y-m-d', strtotime($request['to_date'] . ' +1 day'));
            } else {
                // default to from_date + 1 day
                $to_date = date('Y-m-d', strtotime($from_date . ' +1 day'));
            }

            $mice_flights = $mice_flights->whereBetween('booking_date', [$from_date, $to_date]);
        }

        if($request['search']!=null && isset($request['search']) && $request['search']!=""){
            $mice_flights = $mice_flights->where(function ($query) use ($request) {
                $query->where('air_line_name', 'like', '%' . $request['search'] . '%')
                    ->orWhere('supplier_name', 'like', '%' . $request['search'] . '%')
                    ->orWhereHas('mice', function ($query) use ($request) {
                        $query->where('mice_no', 'like', '%' . $request['search'] . '%');
                    });

            });
        }

        $mice_count=$mice_flights->count();

        $mice_flights = $mice_flights
            ->orderBy('id', 'desc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        return response()->json([
            'success' => true,
            'count' => $mice_count,
            'message' => 'Mice Service Flight Lists',
            'data' => $mice_flights
        ]);
    }

    // MICE Service Visa Create
    public function miceVisaCreateUpdate(Request $request)
    {

        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_visa_id' => 'required|integer',
            'passenger_id' => 'nullable|integer',
            'guest_ids' => 'nullable|string',
            'visa_no' => 'nullable|string',
            'passport_no' => 'nullable|string',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;

            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];

            $obj['passenger_visa_id'] = $request['passenger_visa_id']??0;
            $obj['passport_no'] = $request['passport_no'];
            $obj['dob'] = $request['dob'];
            $obj['guest_ids'] = $request['guest_ids'];
            $obj['email'] = $request['email'];
            $obj['visa_no'] = $request['visa_no'];
            $obj['visa_type_id'] = $request['visa_type_id'];       //from the masters
            $obj['visa_entry_type'] = $request['visa_entry_type'];
            $obj['country_id'] = $request['country_id']??0;
            $obj['country_name'] = $request['country_name']??null;
            $obj['issue_date'] = $request['issue_date'];
            $obj['expiry_date'] = $request['expiry_date'];
            $obj['days'] = $request['days']??0;
            $obj['currency'] = $request['currency']??null;
            $obj['currency_symbol'] = $request['currency_symbol']??null;
            $obj['visa_entry_name'] = $request['visa_entry_name']??null;
            $obj['visa_type_name'] = $request['visa_type_name']??null;

            $obj['supplier_id'] = $request['supplier_id'];
            $obj['supplier_name'] = $request['supplier_name'];
            $obj['gross_amount'] = $request['gross_amount']??0;
            $obj['tax_percent'] = $request['tax_percent']??0;
            $obj['tax_amount'] = $request['tax_amount']??0;
            $obj['supplier_total'] = $request['supplier_total']??0.0;
            $obj['retain'] = $request['retain']??0;
            $obj['total_amount'] = $request['total_amount']??0;
            $obj['upload_image'] = $request['upload_image'];
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount']??0;
            $obj['charges'] = $request['charges'];
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;

            if ($request['id'] > 0) {
                $visa = MiceServiceVisa::findOrFail($request['id']);

                // Reverse the supplier entry summary
                $mice_passenger=MicePassenger::where('id',$visa['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($visa['total_amount'])??0);
                $mice_passenger->update();    

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();
                
                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $visa['mice_id'])
                    ->where('transaction_id', $visa['id'])
                    ->where('service_name', 'visa')
                    ->delete();

                $visa->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Visa', $visa['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $visa = MiceServiceVisa::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Visa', $visa['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$visa,'visa');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Visa Updated Successfully' : 'MICE Service Visa Created Successfully',
                'data' => $visa
            ];

            return response()->json($response);
        }
    }
    // Cancel a MICE Service Visa entry
    public function miceVisaCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_visa_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {

            $visa = MiceServiceVisa::findOrFail($request['mice_visa_id']);
            $visa->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$visa['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($visa['total_amount'])??0);
            $mice_passenger->update();    
            
            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $visa['mice_id'])
                ->where('transaction_id', $visa['id'])
                ->where('service_name', 'visa')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Visa', $visa['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Visa Cancelled Successfully',
                'data' => $visa
            ]);
        }      
    }

    // MICE Service Car Hire Create
    public function miceCarHireCreateUpdate(Request $request){
        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'vehicle_type_id' => 'required|integer',
            'pickup_location' => 'required',
            'drop_location' => 'required',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);
 
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;
    
            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];
 
            $obj['vehicle_type_id'] = $request['vehicle_type_id']??0;     //from the masters
            $obj['vehicle_type_name'] = $request['vehicle_type_name']??null;     //from the masters
            $obj['days'] = $request['days']??0;
            $obj['pickup_location'] = $request['pickup_location']??null;
            $obj['drop_location'] = $request['drop_location']??null;
            $obj['guest_ids'] = $request['guest_ids']??null;
 
            $obj['supplier_id'] = $request['supplier_id']??0;
            $obj['supplier_name'] = $request['supplier_name'];
            $obj['gross_amount'] = $request['gross_amount']??0.0;         //car_hire_price
            $obj['tax_percent'] = $request['tax_percent']??0.0;
            $obj['tax_amount'] = $request['tax_amount']??0.0;
            $obj['supplier_total'] = $request['supplier_total']??0.0;
            $obj['retain'] = $request['retain']??0.0;
            $obj['total_amount'] = $request['total_amount']??0.0;
            $obj['upload_image'] = $request['upload_image']??null;
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount']??0.0;
            $obj['charges'] = $request['charges']??null;
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;

            if ($request['id'] > 0) {
                $car_hire = MiceServiceCarHire::findOrFail($request['id']);

                $mice_passenger=MicePassenger::where('id',$car_hire['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($car_hire['total_amount'])??0);
                $mice_passenger->update();

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $car_hire['mice_id'])
                    ->where('transaction_id', $car_hire['id'])
                    ->where('service_name', 'car_hire')
                    ->delete();

                $car_hire->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Car Hire', $car_hire['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $car_hire = MiceServiceCarHire::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Car Hire', $car_hire['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$car_hire,'car_hire');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Car Hire Updated Successfully' : 'MICE Service Car Hire Created Successfully',
                'data' => $car_hire
            ];

            return response()->json($response);
        }
    }
    // Cancel a MICE Service Car Hire entry
    public function miceCarHireCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_car_hire_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {
 
            $car_hire = MiceServiceCarHire::findOrFail($request['mice_car_hire_id']);
            $car_hire->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$car_hire['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($car_hire['total_amount'])??0);
            $mice_passenger->update();

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $car_hire['mice_id'])
                ->where('transaction_id', $car_hire['id'])
                ->where('service_name', 'car_hire')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Car Hire', $car_hire['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Car Hire Cancelled Successfully',
                'data' => $car_hire
            ]);
        }      
    }

    // MICE Service Assists Create
    public function miceAsistsCreateUpdate(Request $request){
        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_id' => 'required|integer',
            'airport_name' => 'required',
            'no_of_persons' => 'required',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);
 
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;
    
            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];
 
            $obj['airport_id'] = $request['airport_id']??0;     //from the masters
            $obj['airport_name'] = $request['airport_name'];     //from the masters
            $obj['meeting_type'] = $request['meeting_type']??null;
            $obj['no_of_persons'] = $request['no_of_persons']??0;
            $obj['guest_ids'] = $request['guest_ids']??null;
 
            $obj['supplier_id'] = $request['supplier_id']??0;
            $obj['supplier_name'] = $request['supplier_name'];
            $obj['gross_amount'] = $request['gross_amount']??0.0;         //Assists price
            $obj['tax_percent'] = $request['tax_percent']??0.0;
            $obj['tax_amount'] = $request['tax_amount']??0.0;
            $obj['retain'] = $request['retain']??0.0;
            $obj['total_amount'] = $request['total_amount']??0.0;
            $obj['supplier_total'] = $request['supplier_total']??0.0;
            $obj['upload_image'] = $request['upload_image']??null;
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount']??0.0;
            $obj['charges'] = $request['charges']??null;
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;

            if ($request['id'] > 0) {
                $assists = MiceServiceAssist::findOrFail($request['id']);

                $mice_passenger=MicePassenger::where('id',$assists['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($assists['total_amount'])??0);
                $mice_passenger->update();

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $assists['mice_id'])
                    ->where('transaction_id', $assists['id'])
                    ->where('service_name', 'assist')
                    ->delete();

                $assists->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Assists', $assists['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $assists = MiceServiceAssist::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Assists', $assists['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$assists,'assist');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Assists Updated Successfully' : 'MICE Service Assists Created Successfully',
                'data' => $assists
            ];

            return response()->json($response);
        }
    }
    // Cancel a MICE Service Assists entry
    public function miceAsistsCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_assists_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {
 
            $assists = MiceServiceAssist::findOrFail($request['mice_assists_id']);
            $assists->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$assists['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($assists['total_amount'])??0);
            $mice_passenger->update();

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $assists['mice_id'])
                ->where('transaction_id', $assists['id'])
                ->where('service_name', 'assist')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Assists', $assists['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Assists Cancelled Successfully',
                'data' => $assists
            ]);
        }      
    }


     // MICE Service Insurance Create
    public function miceInsuranceCreateUpdate(Request $request){
        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_id' => 'required|integer',
            'passenger_insurance_id' => 'required|integer',
            'policy_no' => 'required',
            'insurance_plan' => 'required',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);
 
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;
    
            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];
 
            $obj['passenger_insurance_id'] = $request['passenger_insurance_id']??0;     //from the masters
            $obj['company_name'] = $request['company_name'];     //from the masters
            $obj['policy_no'] = $request['policy_no']??null;
            $obj['insurance_plan'] = $request['insurance_plan']??0;
            $obj['expiry_date'] = $request['expiry_date']??null;
            $obj['issue_date'] = $request['issue_date']??null;
            $obj['guest_ids'] = $request['guest_ids']??null;
 
            $obj['supplier_id'] = $request['supplier_id']??0;
            $obj['supplier_name'] = $request['supplier_name'];
            $obj['gross_amount'] = $request['gross_amount']??0.0;         //Insurance price
            $obj['tax_percent'] = $request['tax_percent']??0.0;
            $obj['tax_amount'] = $request['tax_amount']??0.0;
            $obj['supplier_total'] = $request['supplier_total']??0.0;
            $obj['retain'] = $request['retain']??0.0;
            $obj['total_amount'] = $request['total_amount']??0.0;
            $obj['upload_image'] = $request['upload_image']??null;
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount']??0.0;
            $obj['charges'] = $request['charges']??null;
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;

            if ($request['id'] > 0) {
                $insurance = MiceServiceInsurance::findOrFail($request['id']);

                $mice_passenger=MicePassenger::where('id',$insurance['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($insurance['total_amount'])??0);
                $mice_passenger->update();

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $insurance['mice_id'])
                    ->where('transaction_id', $insurance['id'])
                    ->where('service_name', 'insurance')
                    ->delete();

                $insurance->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Insurance', $insurance['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $insurance = MiceServiceInsurance::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Insurance', $insurance['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$insurance,'insurance');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Insurance Updated Successfully' : 'MICE Service Insurance Created Successfully',
                'data' => $insurance
            ];

            return response()->json($response);
        }
    }
    // Cancel a MICE Service Insurance entry
    public function miceInsuranceCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_insurance_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {
 
            $insurance = MiceServiceInsurance::findOrFail($request['mice_insurance_id']);
            $insurance->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$insurance['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($insurance['total_amount'])??0);
            $mice_passenger->update();

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $insurance['mice_id'])
                ->where('transaction_id', $insurance['id'])
                ->where('service_name', 'insurance')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Insurance', $insurance['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Insurance Cancelled Successfully',
                'data' => $insurance
            ]);
        }      
    }

     // MICE Service Others Create
    public function miceOthersCreateUpdate(Request $request){
        // Validate the input
        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_id' => 'required|integer',
            'item_id' => 'required|integer',
            'quantity' => 'required',
            'price' => 'required',
            'tax_percent' => 'nullable|numeric',
            'tax_amount' => 'nullable|numeric',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);
 
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        } else {
            // Activity Service
            $activity = new ActivityService;
    
            $obj = [];
            $obj['mice_id'] = $request['mice_id'];
            $obj['passenger_id'] = $request['passenger_id'];
            $obj['entry_type'] = $request['entry_type'];
 
            $obj['item_id'] = $request['item_id']??0;     //from the Item table
            $obj['item_name'] = $request['item_name'];   
            $obj['quantity'] = $request['quantity']??0;
            $obj['price'] = $request['price']??0;
 
            $obj['supplier_id'] = $request['supplier_id']??0;
            $obj['supplier_name'] = $request['supplier_name'];
            $obj['gross_amount'] = $request['gross_amount']??0.0;         // price
            $obj['tax_percent'] = $request['tax_percent']??0.0;
            $obj['tax_amount'] = $request['tax_amount']??0.0;
            $obj['supplier_total'] = $request['supplier_total']??0.0;
            $obj['retain'] = $request['retain']??0.0;
            $obj['total_amount'] = $request['total_amount']??0.0;
            $obj['upload_image'] = $request['upload_image']??null;
            $obj['note'] = $request['note'];
            $obj['discount'] = $request['discount']??0.0;
            $obj['charges'] = $request['charges']??null;
            $obj['supplier_amount'] = $request['supplier_amount']??0;
            $obj['supplier_tax'] = $request['supplier_tax']??0;
            $obj['customer_amount'] = $request['customer_amount']??0;

            if ($request['id'] > 0) {
                $others = MiceServiceOther::findOrFail($request['id']);

                 $mice_passenger=MicePassenger::where('id',$others['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($others['total_amount'])??0);
                $mice_passenger->update();

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $others['mice_id'])
                    ->where('transaction_id', $others['id'])
                    ->where('service_name', 'others')
                    ->delete();

                $others->update($obj);

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Others', $others['id'], 'Updated');
            } else {
                // Create the MICE Service Hotel
                $others = MiceServiceOther::create($obj);

                $mice_passenger=MicePassenger::where('id',$request['passenger_id'])->first();
                $mice_passenger['service_total']=(float)($mice_passenger['service_total']) + ((float)($obj['total_amount'])??0);
                $mice_passenger->update();

                // Creating Activities
                $activity->activityCreateUpdate('MICE Service Others', $others['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$others,'others');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'MICE Service Others Updated Successfully' : 'MICE Service Others Created Successfully',
                'data' => $others
            ];

            return response()->json($response);
        }
    }
    // Cancel a MICE Service Others entry
    public function miceOthersCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_others_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {
 
            $others = MiceServiceOther::findOrFail($request['mice_others_id']);
            $others->update(['is_cancle' => 1]);

            $mice_passenger=MicePassenger::where('id',$others['passenger_id'])->first();
            $mice_passenger['service_total']=(float)($mice_passenger['service_total']) - ((float)($others['total_amount'])??0);
            $mice_passenger->update();

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $others['mice_id'])
                ->where('transaction_id', $others['id'])
                ->where('service_name', 'others')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('MICE Service Others', $others['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Others Cancelled Successfully',
                'data' => $others
            ]);
        }      
    }

       // Tour Package Details
    public function tourPackageController(Request $request){

        $validator = validator($request->all(), [
            'mice_id' => 'required|integer',
            'passenger_id' => 'required|integer',
            'tour_package_id'=>'required|integer',
            'days'=>'required',
            'retain' => 'nullable|numeric',
            'total_amount' => 'nullable|numeric'
        ]);

        $obj['mice_id'] = $request['mice_id'];
        $obj['passenger_id'] = $request['passenger_id'];
        $obj['tour_package_id'] = $request['tour_package_id'];
        $obj['package_name'] = $request['package_name'];
        $obj['hotel_type'] = $request['hotel_type'];
        $obj['meal_id'] = $request['meal_id'];
        $obj['is_transport'] = $request['is_transport']??0;
        $obj['days'] = $request['days'];
        $obj['destination'] = $request['destination'];

        $obj['guest_ids'] = $request['guest_ids']??null;
 
        $obj['supplier_id'] = $request['supplier_id']??0;
        $obj['supplier_name'] = $request['supplier_name'];
        $obj['gross_amount'] = $request['gross_amount']??0.0;         //car_hire_price
        $obj['tax_percent'] = $request['tax_percent']??0.0;
        $obj['supplier_total'] = $request['supplier_total']??0.0;
        $obj['tax_amount'] = $request['tax_amount']??0.0;
        $obj['retain'] = $request['retain']??0.0;
        $obj['total_amount'] = $request['total_amount']??0.0;
        $obj['upload_image'] = $request['upload_image']??null;
        $obj['note'] = $request['note'];
        $obj['discount'] = $request['discount']??0.0;
        $obj['charges'] = $request['charges']??null;
        $obj['supplier_amount'] = $request['supplier_amount']??0;
        $obj['supplier_tax'] = $request['supplier_tax']??0;
        $obj['customer_amount'] = $request['customer_amount']??0;

            if ($request['id'] > 0) {
                $tour = MiceServiceTour::findOrFail($request['id']);

                $dsr_passenger = MicePassenger::where('id', $tour['passenger_id'])->first();
                $dsr_passenger['service_total'] = (float) $dsr_passenger['service_total'] 
                    - ((float) ($tour['total_amount'] ?? 0));
                $dsr_passenger->update();

                $dsr_passenger = MicePassenger::where('id', $request['passenger_id'])->first();
                $dsr_passenger['service_total'] = (float) $dsr_passenger['service_total'] 
                    + ((float) ($obj['total_amount'] ?? 0));
                $dsr_passenger->update();   

                // Delete Supplier Summary
                MiceSupplierSummary::where('mice_id', $tour['mice_id'])
                    ->where('transaction_id', $tour['id'])
                    ->where('service_name', 'tour_package')
                    ->delete();

                $tour->update($obj);
                
                // Creating Activities
                $activity = new ActivityService;
                $activity->activityCreateUpdate('Mice Service tour package', $tour['id'], 'Updated');
            } else {
                // Create the DSR Service Hotel
                $tour = MiceServiceTour::create($obj);

                $dsr_passenger = MicePassenger::where('id', $request['passenger_id'])->first();
                $dsr_passenger['service_total'] = (float) $dsr_passenger['service_total'] 
                    + ((float) ($obj['total_amount'] ?? 0));

                $dsr_passenger->update();

                // Creating Activities
                $activity = new ActivityService;
                $activity->activityCreateUpdate('Mice Service tour package', $tour['id'], 'Created');
            }

            // Creating supplier entry summary
            if($request['supplier_id']>0){
                $supplier_summary = new SupplierSummary;
                $supplier_summary->miceSupplierSummaryCreate($request,$tour,'tour_package');
            }

            $response = [
                'success' => true,
                'message' => $request['id'] > 0 ? 'Mice Service tour package Updated Successfully' : 'Mice Service tour package Created Successfully',
                'data' => $tour
            ];

            return response()->json($response);
        
    }

     // Cancel a DSR Service Insurance entry
    public function miceTourPackageCancel(Request $request)
    {
        // Validate the input
        $validator = validator($request->all(), [
            'mice_tour_package_id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {
 
            $tour = MiceServiceTour::findOrFail($request['mice_tour_package_id']);
            $tour->update(['is_cancle' => 1]);

            $dsr_passenger = MicePassenger::where('id', $tour['passenger_id'])->first();
                $dsr_passenger['service_total'] = (float) $dsr_passenger['service_total'] 
                    - ((float) ($tour['total_amount'] ?? 0));

            $dsr_passenger->update();

            // Delete Supplier Summary
            MiceSupplierSummary::where('mice_id', $tour['mice_id'])
                ->where('transaction_id', $tour['id'])
                ->where('service_name', 'tour_package')
                ->delete();

            // Activity Service
            $activity = new ActivityService;
            $activity->activityCreateUpdate('Mice Service Tour Package with id', $tour['id'], 'Cancelled');

            return response()->json([
                'success' => true,
                'message' => 'Mice Service Tour Package Cancelled Successfully',
                'data' => $tour
            ]);
        }      
    }

    
    //get all details service by a pessenger id
    public function getMiceServiceHotelByPassengerId(Request $request)
    {
        $validator = validator($request->all(), [
            'passenger_id' => 'required|integer'
        ]);

        if ($validator->fails()) {

            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);

        } else {

            $mice_passenger=MicePassenger::where('id',$request['passenger_id'])
                ->with('passenger','mice:id,mice_no')
                ->first();

            $dsrServiceHotel = MiceServiceHotel::where('passenger_id', $request['passenger_id'])
                ->with('hotel','room:id,room_number')
                ->where('is_cancle',0)
                ->orderBy('id','desc')
                ->get();

                foreach ($dsrServiceHotel as $key => $hotel) {
                    $guestIds = explode(',', $hotel['guest_ids'] ?? '');
                    $hotel['guests']=User::whereIn('id',$guestIds)->get();
                }

            $dsrServicFlight = MiceServiceFlight::where('passenger_id', $request['passenger_id'])
                ->where('is_cancle',0)
                // ->with()
                ->orderBy('id','desc')
                ->get();

                foreach ($dsrServicFlight as $key => $flight) {
                    $guestIds = explode(',', $flight['guest_ids'] ?? '');
                    $flight['guests']=User::whereIn('id',$guestIds)->get();
                }

            $dsrServicVisa = MiceServiceVisa::where('passenger_id', $request['passenger_id'])
                ->where('is_cancle',0)
                ->with('visa_passenger:id,display_name','country:id,name')
                ->orderBy('id','desc')
                ->get();

                foreach ($dsrServicVisa as $key => $visa) {
                    $guestIds = explode(',', $visa['guest_ids'] ?? '');
                    $visa['guests']=User::whereIn('id',$guestIds)->get();
                }

            $dsrServicAssist = MiceServiceAssist::where('passenger_id', $request['passenger_id'])
                ->where('is_cancle',0)
                // ->with('visa_passenger:id,display_name','country:id,name')
                ->orderBy('id','desc')
                ->get();

                foreach ($dsrServicAssist as $key => $assist) {
                    $guestIds = explode(',', $assist['guest_ids'] ?? '');
                    $assist['guests']=User::whereIn('id',$guestIds)->get();
                }

            $dsrServicCarHire = MiceServiceCarHire::where('passenger_id', $request['passenger_id'])
                ->where('is_cancle',0)
                // ->with('visa_passenger:id,display_name','country:id,name')
                ->orderBy('id','desc')
                ->get();

                foreach ($dsrServicCarHire as $key => $car_hire) {
                    $guestIds = explode(',', $car_hire['guest_ids'] ?? '');
                    $car_hire['guests']=User::whereIn('id',$guestIds)->get();
                }

            $dsrServicInsurance = MiceServiceInsurance::where('passenger_id', $request['passenger_id'])
                ->where('is_cancle',0)
                ->with('passenger')
                ->orderBy('id','desc')
                ->get();

            foreach ($dsrServicInsurance as $key => $insurance) {
                $guestIds = explode(',', $insurance['guest_ids'] ?? '');
                $insurance['guests']=User::whereIn('id',$guestIds)->get();
            }

            $dsrServicOthers = MiceServiceOther::where('passenger_id', $request['passenger_id'])
                ->where('is_cancle',0)
                ->orderBy('id','desc')
                ->get();

            $dsrServicTour = MiceServiceTour::where('passenger_id', $request['passenger_id'])
                ->with('tour_package')
                ->where('is_cancle',0)
                ->orderBy('id','desc')
                ->get();

            foreach ($dsrServicTour as $key => $tour) {
                $guestIds = explode(',', $tour['guest_ids'] ?? '');
                $tour['guests']=User::whereIn('id',$guestIds)->get();
            }

            return response()->json([
                'success' => true,
                'message' => 'MICE Service Passenger Details fetched',
                'mice_passenger'=>$mice_passenger,
                'mice_hotel' => $dsrServiceHotel,
                'mice_flight' => $dsrServicFlight,
                'mice_visa' => $dsrServicVisa,
                'mice_assist' => $dsrServicAssist,
                'mice_insurance' => $dsrServicInsurance,
                'mice_others' => $dsrServicOthers,
                'mice_car_hire' => $dsrServicCarHire,
                'mice_tour' => $dsrServicTour
            ]);
            
        }
    }


  

}
