<?php

namespace App\Http\Controllers\Api\Payroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payroll\PaySlip;
use Auth;


class PaySlipController extends Controller

{
   
    public function payslipCreateUpdate(Request $request){
        $auth=Auth::user();
        try{
            $obj['employee_name'] = $request['employee_name']; 
            $obj['employee_id'] = $request['employee_id']; 
            $obj['pay_period'] = $request['pay_period']; 
            $obj['paid_days'] = $request['paid_days']; 
            $obj['loss_of_pay_days'] = $request['loss_of_pay_days']; 
            $obj['pay_date'] = $request['pay_date']; 
            $obj['payment_mode_id'] = $request['payment_mode_id']; 
            $obj['bank_name'] = $request['bank_name']; 
            $obj['account_no'] = $request['account_no']; 
            $obj['ifsc'] = $request['ifsc']; 

            if($request->id>0){
                try{
                    $payslip=PaySlip::findOrFail($request['id']);
                    $payslip->update($obj);

                } catch (\Exception $e) {
                    return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                }
            }else{
                $payslip=PaySlip::create($obj);
            }
            return response()->json([
                'status'=>200,
                'message'=> $request->id>0 ? 'Pay Slip update successfully':'Pay Slip created Successfully',
                'result'=>$payslip
            ],200);
        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }
    public function getPaySlips(Request $request){

        $user=Auth::user();
        
        if($user!=null){
        
            $payslip=PaySlip::where('is_disabled',0);
            $count=$payslip->count();
            $payslip = $payslip->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$payslip,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {

            $response=[
                'result'=>$payslip,
                'count'=>$count,
                'message'=>'Failed'
            ];
        }

        return response()->json($response);
    }
    public function enableDisablePayslip(Request $request){
        $user=Auth::user();
        if($user!=null){
            $payslip=PaySlip::where('id',$request['id'])->first();
            if($payslip!=null){
                $payslip['is_disabled'] = $request['is_disabled'];
                $payslip->update();
            }
            $response=[
                'result'=>true,
                'message'=>'Successful',
            ];
        } else {
            $response=[
                'result'=>false,
                'message'=>'Failed'
            ];
        }
        return response()->json($response);
    }

}
