<?php

namespace App\Http\Controllers\Api\Payroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payroll\SalaryComponent;
use Auth;


class SalaryComponentController extends Controller

{
   
    public function componentCreateUpdate(Request $request){
        $auth=Auth::user();
        try{
            $obj['name'] = $request['name']; 
            $obj['name_type'] = $request['name_type']; 
            $obj['name_in_payslip'] = $request['name_in_payslip']; 
            $obj['calculation_type'] = $request['calculation_type']; 
            $obj['component_type'] = $request['component_type']; 
            $obj['other_configuration'] = $request['other_configuration']; 
            $obj['recurring_type'] = $request['recurring_type']; 
            $obj['is_active'] = $request['is_active']; 
            
            if($request->id>0){
                try{
                    $component=SalaryComponent::findOrFail($request['id']);
                    $component->update($obj);

                } catch (\Exception $e) {
                    return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                }
            }else{
                $component=SalaryComponent::create($obj);
            }
            return response()->json([
                'status'=>200,
                'message'=> $request->id>0 ? 'Component update successfully':'Component created Successfully',
                'result'=>$component
            ],200);
        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }
    public function getComponents(Request $request){

        $user=Auth::user();
        
        if($user!=null){
        
            $component=SalaryComponent::where('is_disabled',0);
            if(isset($request['component_type']) && $request['component_type']!='' && $request['component_type']!=0){
               $component = $component->where('component_type',$request['component_type']);
            }
            $count=$component->count();
            $component = $component->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$component,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {

            $response=[
                'result'=>$component,
                'count'=>$count,
                'message'=>'Failed'
            ];
        }

        return response()->json($response);
    }
    public function enableDisableComponent(Request $request){
        $user=Auth::user();
        if($user!=null){
            $component=SalaryComponent::where('id',$request['id'])->first();
            if($component!=null){
                // $component['is_disabled'] = $component['is_disabled']==1 ? 0 : 1;
                $component['is_disabled'] = $request['is_disabled'];
                $component->update();
            }
            $response=[
                'result'=>true,
                'message'=>'Successful',
            ];
        } else {
            $response=[
                'result'=>false,
                'message'=>'Failed'
            ];
        }
        return response()->json($response);
    }

}
