<?php

namespace App\Http\Controllers\Api\Payroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payroll\SalaryDetail;
use Auth;


class SalaryDetailController extends Controller

{
   
    public function detailCreateUpdate(Request $request){
        $auth=Auth::user();
        try{
            $obj['emoployee_name'] = $request['emoployee_name']; 
            $obj['employee_id'] = $request['employee_id']; 
            $obj['department_id'] = $request['department_id']; 
            $obj['designation'] = $request['designation']; 
            $obj['bank_name'] = $request['bank_name']; 
            $obj['account_no'] = $request['account_no']; 
            $obj['ifsc'] = $request['ifsc']; 
            $obj['tax_percentage'] = $request['tax_percentage']; 
            $obj['salary_month'] = $request['salary_month']; 
            $obj['payment_mode_id'] = $request['payment_mode_id']; 
            $obj['basic_salary'] = $request['basic_salary']; 
            
            if($request->id>0){
                try{
                    $detail=SalaryDetail::findOrFail($request['id']);
                    $detail->update($obj);

                } catch (\Exception $e) {
                    return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                }
            }else{
                $detail=SalaryDetail::create($obj);
            }
            return response()->json([
                'status'=>200,
                'message'=> $request->id>0 ? 'Salery Details update successfully':'Salary Details created Successfully',
                'result'=>$detail
            ],200);
        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }
    public function getSalaryDetails(Request $request){

        $user=Auth::user();
        
        if($user!=null){
        
            $detail=SalaryDetail::where('is_disabled',0);
            $count=$detail->count();
            $detail = $detail->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$detail,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {

            $response=[
                'result'=>$detail,
                'count'=>$count,
                'message'=>'Failed'
            ];
        }

        return response()->json($response);
    }
    public function enableDisableDetail(Request $request){
        $user=Auth::user();
        if($user!=null){
            $detail=SalaryDetail::where('id',$request['id'])->first();
            if($detail!=null){
                $detail['is_disabled'] = $request['is_disabled'];
                $detail->update();
            }
            $response=[
                'result'=>true,
                'message'=>'Successful',
            ];
        } else {
            $response=[
                'result'=>false,
                'message'=>'Failed'
            ];
        }
        return response()->json($response);
    }

}
