<?php

namespace App\Http\Controllers\Api\Payroll;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payroll\StatutoryComponent;
use Auth;


class StatutoryComponentController extends Controller

{
   
    public function componentCreateUpdate(Request $request){
        $auth=Auth::user();
        try{
            
            $obj['epf_number'] = $request['epf_number'];
            $obj['esi_number'] = $request['esi_number'];
            $obj['component_type'] = $request['component_type'];
            $obj['deduction_cycle'] = $request['deduction_cycle'];
            $obj['employee_contribution'] = $request['employee_contribution'];
            $obj['employer_contribution'] = $request['employer_contribution'];
            $obj['other_configuration'] = $request['other_configuration'];
            
            if($request->id>0){
                try{
                    $component=StatutoryComponent::findOrFail($request['id']);
                    $component->update($obj);

                } catch (\Exception $e) {
                    return response(['error' => true, 'message' => 'Invalid Id to update'], 404); 
                }
            }else{
                $component=StatutoryComponent::create($obj);
            }
            return response()->json([
                'status'=>200,
                'message'=> $request->id>0 ? 'Component update successfully':'Component created Successfully',
                'result'=>$component
            ],200);
        } catch (\Exception $e) {
            return response(['error' => true, 'message' => $e->getMessage()], 404); 
        }
    }
    public function getComponents(Request $request){

        $user=Auth::user();
        
        if($user!=null){
        
            $component=StatutoryComponent::where('is_disabled',0);
            if(isset($request['component_type']) && $request['component_type']!='' && $request['component_type']!=0){
                $component = $component->where('component_type',$request['component_type']);
             }
            $count=$component->count();
            $component = $component->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            $response=[
                'result'=>$component,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {

            $response=[
                'result'=>$component,
                'count'=>$count,
                'message'=>'Failed'
            ];
        }

        return response()->json($response);
    }
    public function enableDisableComponent(Request $request){
        $user=Auth::user();
        if($user!=null){
            $column = $request['column'];
            $value = $request['value'];
            $component=StatutoryComponent::where('id',$request['id'])->first();
            if($component!=null){
                // $component['is_disabled'] = $component['is_disabled']==1 ? 0 : 1;
                $component['is_disabled'] = $request['is_disabled'];
                $component->update();
            }
            $response=[
                'result'=>true,
                'message'=>'Successful',
            ];
        } else {
            $response=[
                'result'=>false,
                'message'=>'Failed'
            ];
        }
        return response()->json($response);
    }

}
