<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\Product;

class ProductController extends Controller
{
    //Creating  a new product function
    public function productCreateUpdate(Request $request){
        $user=Auth::user();
        $obj['name']=$request['name'];
        $obj['icon']=$request['icon'];
        $obj['title']=$request['title'];
        $obj['description']=$request['description'];
        $obj['isdisabled']=$request['isdisabled']??0;
        $obj['groupid']=$request['groupid']??0;
        $obj['iselement']=$request['iselement']??0;
        $obj['isquantity']=$request['isquantity']??0;
        $obj['israw']=$request['israw']??0;
        $obj['symbol']=$request['symbol'];
        $obj['unit']=$request['unit'];

        // Check if id exists then update otherwise create the data.
        if($request['id']>0){
            try{
                // Updating an existing  product
                $product=Product::findOrFail($request['id']);
                $product->update($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Product',$product['id'],'Updated');

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }
            
        }else{

            // Creating a new Product
            $product=Product::create($obj);

            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Product',$product['id'],'Created');
        }

        return response()->json($product);
    }
    
    public function fetchProduct(Request $request){

        $user=Auth::user();

        $product=Item::where('isdisabled',0)->with('category');

        // Fucntion for filtering the Items
        $product=$this->productbyquery($product,$request);

        //  Getting total count of items after filtration
        $count=$product->count();

        // Pagination
        $product=$product->skip($request['noofrec']??100* $request['currentpage']-1)->take($request['noofrec']??50)->get();

        $response=[
            'products'=>$product,
            'count'=>$count
        ];
        return response()->json($response);
    }

    // Function to filter a Item
    public function productbyquery($product,$request){
        if(isset($request['israw']) && $request['israw']!=0){
            $product=$product->where('israw',$request['israw']);
        }
        if(isset($request['isquantity']) && $request['isquantity']!=0){
            $product=$product->where('isquantity',$request['isquantity']);
        }
        if(isset($request['isconsumable'])&& $request['isconsumable']!=0){
            $product=$product->where('isconsumable',$request['isconsumable']);
        } 
        if(isset($request['iselement'])&& $request['iselement']!=0){
            $product=$product->where('iselement',$request['iselement']);
        } 
        return $product;
    }

    // Function to fetch a product by a category
    public function fetchProductBycategory(Request $request){

        // Fetching Product by a category
        $item=Item::where('isdisabled',0)->where('categoryid',$request['categoryid'])->get();

        return response()->json($item);
    }
}
