<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Naksha\Accommodation;

class AccommodationController extends Controller
{
    //Create Update
    public function accommodationCreateUpdate(Request $request) {
        $validator=validator($request->all(),[
            'tour_package_id'=>'required',
            'name'=>'required',
            'start_date'=>'required',
            'end_date'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $obj['tour_package_id']=$request['tour_package_id'];
            $obj['name']=$request['name'];
            $obj['tour_destination']=$request['tour_destination']; // name of tour destination from tour destination APi
            $obj['description']=$request['description'];
            $obj['your_stay']=$request['your_stay'];
            $obj['your_room']=$request['your_room'];
            $obj['meal']=$request['meal'];
            $obj['fast_facts']=$request['fast_facts'];
            $obj['attachments']=$request['attachments'];
            $obj['start_date']=$request['start_date'];
            $obj['end_date']=$request['end_date'];

            if($request['id']>0){
                $accommodation=Accommodation::findOrFail($request['id']);
                $accommodation->update($obj);
            }else{
                $accommodation=Accommodation::create($obj);
            }

            return [
                'success' => true, 
                'message' => 'Success Accommodation',
                'data' => $accommodation
            ];
        }
    }

    public function accommodationList(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        }
        $accommodation=Accommodation::where('tour_package_id',$request['tour_package_id'])
            ->where('is_deleted',0)->get();
        return [
            'success' => true, 
            'data' => $accommodation,
            'message' => 'Accommodation Lists'
        ];
    }

    public function accommodationDetails(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]); 

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $accommodation=Accommodation::findOrFail($request['id']);
            return [
                'success' => true, 
                'data' => $accommodation,
                'message' => 'Accommodation Details'
            ];
        }
    }

    public function deleteAccommodation(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $accommodation=Accommodation::findOrFail($request['id']);
            $accommodation['is_deleted']=1;
            $accommodation->update();
            return [
                'success' => true, 
                'message' => 'Accommodation Deleted Successfully'
            ];
        }
    }
}
