<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Airport;

class AirportController extends Controller
{
    public function airportCreateUpdate(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'name'=>'required|string',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $category=[];

            $obj['name']=$request['name'];
            $obj['city']=$request['city'];
            $obj['country']=$request['country'];
            $obj['iata_code']=$request['iata_code'];
            $obj['icao_code']=$request['icao_code'];

            if($request['id'] >0){

                try{
                    // Existing Id Then Update
                    $airport=Airport::findOrFail($request['id']);
                    $airport->update($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Airport',$airport['id'],'Updated');
                    
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else{

                // Check if Duplicate Airport
                if($obj['name'] != null && $obj['name'] != ''){

                    // Check Duplicate Name
                    $checkName = Airport::where('name', $obj['name']);

                    $checkName = $checkName->first();
                
                    if($checkName != null){
                        $response = [
                            'airport' => $checkName,
                            'success' => false,
                            'message' => 'Duplicate Name '. $checkName['name'] .' Found!'
                        ];
                
                        return response()->json($response);
                    }
                }

                // Create new Airport
                $airport=Airport::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Airport',$airport['id'],'Created');
            }
            $response=[
                'success'=>true,
                'message'=>$request['id']>0? "Airport Updated Successfully":"Airport Created Successfully",
                'data'=>$airport
            ];
        }

        return response()->json($response);
    }

    public function airportList(Request $request){
        
        $airport=Airport::query();

        if(isset($request['id']) && $request['id']>0){
            $airport=$airport->where('id',$request['id']);
        }

        if($request['search']!=null && $request['search']!=''){

            $airport = $airport->where(function ($query) use ($request) {

                // $query->where('name', 'LIKE', '%' . $request['search'] . '%')

                // ->orWhere('city', 'LIKE', '%' . $request['search'] . '%')
                // ->orWhere('country', 'LIKE', '%' . $request['search'] . '%')
                $query->orWhere('iata_code', $request['search'])
                ->orWhere('icao_code',$request['search']);
            });
        }

        $count=$airport->count();

        $airport =$airport->orderBy('id','desc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$airport
        ];

        return response()->json($response);
    }
}
