<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Assist;
use Auth;

class AssistController extends Controller
{
    public function assistCreateupdate(Request $request){

        $validator=validator($request->all(),[
            'meeting_type'=>'required',
            'no_of_person' => 'required',
            'airport'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $obj['meeting_type']=$request['meeting_type'];
            $obj['airport']=$request['airport'];
            $obj['no_of_person']=$request['no_of_person']??0;
            $obj['currency']=$request['currency'];
            $obj['price']=$request['price']??0.0;
            $obj['description']=$request['description'];

            if($request['id']>0){

                try {
                        
                    $assists=Assist::findOrFail($request['id']);

                    $assists->update($obj);
                //
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }
            }else{
                $assists=Assist::create($obj);
            }

            $response=[
                'success'=>true,
                'data'=>$assists,
                'message'=>$request['id']>0?'Assists Updated Successfully':"Assists Added Successfully",
            ];
    
            return response()->json($response);
        }
        
    }

    // List Of Tour Packages
     public function getAssistlists(Request $request){

        $user=Auth::user();

        $assistss = Assist::where('is_disabled', 0);

        if($request['meeting_type']!=null && $request['meeting_type']!="" && isset($request['meeting_type'])){
            $assistss=$assistss->where('meeting_type',$request['meeting_type']);
        }

        if($request['no_of_person']!=null && $request['no_of_person']!="" && isset($request['no_of_person'])){
            $assistss=$assistss->where('no_of_person',$request['no_of_person']);
        }

        if($request['airport']!=null && $request['airport']!="" && isset($request['airport'])){
            $assistss=$assistss->where('airport',$request['airport']);
        }

        if($request['status']!=null && $request['status']!=0 && isset($request['status'])){
            $assistss=$assistss->where('status',$request['status']);
        }
        
        if ($request['search'] != null && $request['search'] != '') {

            $searchTerm = $request['search'];
            $assistss = $assistss->where(function ($query) use ($searchTerm) {
                $query->where('meeting_type', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('airport', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('no_of_person', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('price', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('description', 'LIKE', '%' . $searchTerm . '%');
            });
        }
    
        $count=$assistss->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $assistss = $assistss->orderby($request['sort_by'],$sort_order);

        }else{
            $assistss = $assistss->orderby('id','desc');
        }
        
        $assistss=$assistss->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$assistss,
            'message'=>'All Assistss Listed Successfully'
        ];
        
        return response()->json($response);

    } 

    // Details Of Tour Packages
    public function assistDetails(Request $request){

        $validator=validator($request->all(),[
            'assist_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $assists=Assist::findOrFail($request['assist_id']);

            $response=[
                'success'=>true,
                'data'=>$assists,
                'message'=>'Assists Details Fetched Successfully'
            ];
            
            return response()->json($response);

        }
    }

    // Status
    public function changeAssistStatus(Request $request){
        
        $validator=validator($request->all(),[
            'assist_id'=>'required',
            'status'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $assists=Assist::findOrFail($request['assist_id']);
                $assists['status']=$request['status'];

                $assists->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[
                'success'=>true,
                'data'=>$assists,
                'message'=>'Assists Status Updated Successfully',
            ];
    
            return response()->json($response);
        }
    }

     // Delete
    public function deleteAssist(Request $request){
        
        $validator=validator($request->all(),[
            'assist_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $assists=Assist::findOrFail($request['assist_id']);
                $assists['is_disabled']=1;

                $assists->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to Delete '], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'Assist Deleted Successfully'
            ];
    
            return response()->json($response);
        }
    }
}
