<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CarHire;
use Auth;

class CarHireController extends Controller
{
    public function CarHireCreateupdate(Request $request){

        $validator=validator($request->all(),[
            'type_of_vehicle'=>'required',
            'select_days' => 'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $obj['type_of_vehicle']=$request['type_of_vehicle'];
            $obj['vehicle_type_name']=$request['vehicle_type_name']??null;
            $obj['select_days']=$request['select_days']??0;
            $obj['currency']=$request['currency'];
            $obj['price']=$request['price']??0.0;
            $obj['description']=$request['description'];

            if($request['id']>0){

                try {
                        
                    $car_hire=CarHire::findOrFail($request['id']);

                    $car_hire->update($obj);
                //
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }
            }else{
                $car_hire=CarHire::create($obj);
            }

            $response=[
                'success'=>true,
                'data'=>$car_hire,
                'message'=>$request['id']>0?'Car Hire Updated Successfully':"Car Hire Added Successfully",
            ];
    
            return response()->json($response);
        }
        
    }

    // List Of Tour Packages
     public function getCarHirelists(Request $request){

        $user=Auth::user();

        $car_hires = CarHire::where('is_disabled', 0);

        // if($request['car_hire_type']!=null && $request['car_hire_type']!=0 && isset($request['car_hire_type'])){
        //     $car_hires=$car_hires->where('car_hire_type',$request['car_hire_type']);
        // }

        if($request['status']!=null && $request['status']!=0 && isset($request['status'])){
            $car_hires=$car_hires->where('status',$request['status']);
        }
        
        if ($request['search'] != null && $request['search'] != '') {

            $searchTerm = $request['search'];
            $car_hires = $car_hires->where(function ($query) use ($searchTerm) {
                $query->where('type_of_vehicle', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('select_days', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('price', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('description', 'LIKE', '%' . $searchTerm . '%');
            });
        }
    
        $count=$car_hires->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $car_hires = $car_hires->orderby($request['sort_by'],$sort_order);

        }else{
            $car_hires = $car_hires->orderby('id','desc');
        }
        
        $car_hires=$car_hires->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$car_hires,
            'message'=>'All car Hires Listed Successfully'
        ];
        
        return response()->json($response);

    } 

    // Details Of Tour Packages
    public function CarHireDetails(Request $request){

        $validator=validator($request->all(),[
            'car_hire_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $car_hire=CarHire::findOrFail($request['car_hire_id']);

            $response=[
                'success'=>true,
                'data'=>$car_hire,
                'message'=>'Car Hire Details Fetched Successfully'
            ];
            
            return response()->json($response);

        }
    }

    // Status
    public function changeCarHireStatus(Request $request){
        
        $validator=validator($request->all(),[
            'car_hire_id'=>'required',
            'status'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $car_hire=CarHire::findOrFail($request['car_hire_id']);
                $car_hire['status']=$request['status'];

                $car_hire->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[
                'success'=>true,
                'data'=>$car_hire,
                'message'=>'Car Hire Status Updated Successfully',
            ];
    
            return response()->json($response);
        }
    }

    // Delete
    public function deleteCarHire(Request $request){
        
        $validator=validator($request->all(),[
            'car_hire_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $car_hire=CarHire::findOrFail($request['car_hire_id']);
                $car_hire['is_disabled']=1;

                $car_hire->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to Delete '], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'Car Hire Deleted Successfully',
            ];
    
            return response()->json($response);
        }
    }
}
