<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Flight;
use Auth;

class FlightController extends Controller
{
    
    // Flight Create Update
    public function flightCreateUpdate(Request $request){
        $validator=validator($request->all(),[
            'flight_name'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['flight_name']=$request['flight_name'];
            $obj['air_line_code']=$request['air_line_code'];
            $obj['airline_digitcode']=$request['airline_digitcode'];
            $obj['destination_code']=$request['destination_code'];

            if($request['id']>0){

                try {
                        
                    $flight=Flight::findOrFail($request['id']);

                    $flight->update($obj);
                //
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }

            }else{

                $flight=Flight::create($obj);
            }

            $response=[
                'success'=>true,
                'data'=>$flight,
                'message'=>$request['id']>0?'Flight Updated Successfully':"Flight Added Successfully",
            ];
    
            return response()->json($response);
           
        }
    }

    // Get Flight Lists  
    public function getFlights(Request $request){

        $user=Auth::user();

        $flights = Flight::where('is_disabled', 0);

        if($request['status']!=null && $request['status']!=0 && isset($request['status'])){
            $flights=$flights->where('status',$request['status']);
        }
        
        if ($request['search'] != null && $request['search'] != '') {

            $searchTerm = $request['search'];
            $flights = $flights->where(function ($query) use ($searchTerm) {
                $query->where('flight_name', 'LIKE', '%' . $searchTerm . '%');
                $query->orWhere('airline_digitcode', 'LIKE', '%' . $searchTerm . '%');
                $query->orWhere('air_line_code', 'LIKE', '%' . $searchTerm . '%');
            });
        }
    
        $count=$flights->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $flights = $flights->orderby($request['sort_by'],$sort_order);

        }else{
            $flights = $flights->orderby('id','desc');
        }
        
        $flights=$flights->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$flights,
            'message'=>'All Flights Listed Successfully'
        ];
        
        return response()->json($response);

    } 

    // Flights Status
    public function changeFlightStatus(Request $request){
        
        $validator=validator($request->all(),[
            'flight_id'=>'required',
            'status'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $flight=Flight::findOrFail($request['flight_id']);
                $flight['status']=$request['status'];

                $flight->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[
                'success'=>true,
                'data'=>$flight,
                'message'=>'Flight Status Updated Successfully',
            ];
    
            return response()->json($response);
        }
    }

    // Delete
    public function deleteflight(Request $request){
        
        $validator=validator($request->all(),[
            'flight_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $flight=Flight::findOrFail($request['flight_id']);
                $flight['is_disabled']=1;

                $flight->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to Delete '], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'Flight Deleted Successfully',
            ];
    
            return response()->json($response);
        }
    }
}
