<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Insurance;
use Auth;

class InsuranceController extends Controller
{
    // insurance Create Update
    public function insuranceCreateUpdate(Request $request){
        $validator=validator($request->all(),[
            'company_name'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['company_name']=$request['company_name'];

            if($request['id']>0){

                try {
                        
                    $insurance=Insurance::findOrFail($request['id']);

                    $insurance->update($obj);
                //
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }

            }else{

                $insurance=Insurance::create($obj);
            }

            $response=[
                'success'=>true,
                'data'=>$insurance,
                'message'=>$request['id']>0?'Insurance Updated Successfully':"Insurance Added Successfully",
            ];
    
            return response()->json($response);
           
        }
    }

    // Get insurance Lists  
    public function getInsurance(Request $request){

        $user=Auth::user();

        $insurance = Insurance::where('is_disabled', 0);

        if($request['status']!=null && $request['status']!=0 && isset($request['status'])){
            $insurance=$insurance->where('status',$request['status']);
        }
        
        if ($request['search'] != null && $request['search'] != '') {

            $searchTerm = $request['search'];
            $insurance = $insurance->where(function ($query) use ($searchTerm) {
                $query->where('company_name', 'LIKE', '%' . $searchTerm . '%');
            });
        }
    
        $count=$insurance->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $insurance = $insurance->orderby($request['sort_by'],$sort_order);

        }else{
            $insurance = $insurance->orderby('id','desc');
        }
        
        $insurance=$insurance->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$insurance,
            'message'=>'All Insurance Listed Successfully'
        ];
        
        return response()->json($response);

    } 

    // insurance Status
    public function changeInsuranceStatus(Request $request){
        
        $validator=validator($request->all(),[
            'insurance_id'=>'required',
            'status'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $insurance=Insurance::findOrFail($request['insurance_id']);
                $insurance['status']=$request['status'];

                $insurance->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[
                'success'=>true,
                'data'=>$insurance,
                'message'=>'Insurance Status Updated Successfully',
            ];
    
            return response()->json($response);
        }
    }

    // Delete
    public function deleteInsurance(Request $request){
        
        $validator=validator($request->all(),[
            'insurance_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $insurance=Insurance::findOrFail($request['insurance_id']);
                $insurance['is_disabled']=1;

                $insurance->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to Delete '], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'Insurance Deleted Successfully',
            ];
    
            return response()->json($response);
        }
    }
}
