<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Naksha\TourDestination;

class TourDestinationController extends Controller
{
    public function destinationCreateUpdate(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required',
            'tour_name'=>'required',
            'start_date'=>'required',
            'end_date'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['tour_package_id']=$request['tour_package_id'];
            $obj['tour_name']=$request['tour_name'];
            $obj['description']=$request['description'];
            $obj['attachments']=$request['attachments'];
            $obj['accommodation_id']=$request['accommodation_id'];
            $obj['start_date']=$request['start_date']??null;
            $obj['end_date']=$request['end_date']??null;
            $obj['meal']=$request['meal'];  // Breakfast, Lunch, Dinner

            if($request['id']>0){
                $tour=TourDestination::findOrFail($request['id']);
                $tour->update($obj);
            }else{
                //Check duplicate destination name
                $tour=TourDestination::where('tour_package_id',$request['tour_package_id'])
                ->where('tour_name',$request['tour_name'])
                ->where('is_deleted',0)->first();
                
                if($tour){
                    return [
                        'success' => false, 
                        'message' => 'Duplicate Destination Name'
                    ];
                }
                $tour=TourDestination::create($obj);
            }

            return [
                'success' => true, 
                'message' => 'Success',
                'data' => $tour
            ];
        }
    }

    public function tourDestinationList(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        }
        $tour=TourDestination::where('tour_package_id',$request['tour_package_id'])
            ->with('accommodation')
            ->where('is_deleted',0)->get();
        return [
            'success' => true, 
            'data' => $tour,
            'message' => 'Tour Destination Lists'
        ];
    }

    public function tourDestinationDetails(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $tour=TourDestination::findOrFail($request['id']);
            return [
                'success' => true, 
                'data' => $tour,
                'message' => 'Tour Destination Details'
            ];
        }
    }

    //Delete Tour Destination
    public function deleteTourDestination(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $tour=TourDestination::findOrFail($request['id']);
            $tour['is_deleted']=1;
            $tour->update();
            return [
                'success' => true, 
                'message' => 'Tour Destination Deleted Successfully'
            ];
        }
    }
}
