<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Naksha\TourOther;

class TourOtherController extends Controller
{
    //
    public function tourOtherCreateUpdate(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required',
            'start_date'=>'required',  
            'end_date'=>'required',  
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['tour_package_id'] = $request['tour_package_id'];
            $obj['name'] = $request['name'];
            $obj['start_date']=$request['start_date'];
            $obj['end_date']=$request['end_date'];        
            $obj['description'] = $request['description'];         // detailed notes
            $obj['attachments'] = $request['attachments'];         // detailed notes

            if($request['id']>0){
                $tour=TourOther::findOrFail($request['id']);
                $tour->update($obj);
            }else{
                $tour=TourOther::create($obj);
            }

            return [
                'success' => true, 
                'message' => 'Saved Successfully',
                'data' => $tour
            ];
        }
    }

    public function tourOthersList(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        }
        $tour=TourOther::where('tour_package_id',$request['tour_package_id'])
            ->where('is_deleted',0)->get();
        return [
            'success' => true, 
            'data' => $tour,
            'message' => 'Tour Others Lists'
        ];
    }

    public function tourOthersDetails(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $tour=TourOther::findOrFail($request['id']);
            return [
                'success' => true, 
                'data' => $tour,
                'message' => 'Tour Other Details'
            ];
        }
    }

    public function deleteTourOther(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $tour=TourOther::findOrFail($request['id']);
            $tour['is_deleted']=1;
            $tour->update();
            return [
                'success' => true, 
                'message' => 'Tour Others Deleted Successfully'
            ];
        }
    }
}
