<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Naksha\TourTravel;
use Log;

class TourTravelController extends Controller
{
    //
    public function travelsCreateUpdate(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required',
            'transport_type'=>'required',
            'start_date'=>'required',  
            'end_date'=>'required',  
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $obj['tour_package_id'] = $request['tour_package_id'];
            $obj['transport_type'] = $request['transport_type'];   // e.g. "car", "flight"
            $obj['day'] = $request['day'];                         // e.g. "Day 1"
            $obj['departure'] = $request['departure'];             // e.g. "Delhi"
            $obj['arrival'] = $request['arrival'];                 // e.g. "Agra"
            $obj['pick_up'] = $request['pick_up'];                 // e.g. "Hotel XYZ"
            $obj['drop_off'] = $request['drop_off'];               // e.g. "Airport"
            $obj['description'] = $request['description'];         // detailed notes
            $obj['start_date']=$request['start_date'];
            $obj['end_date']=$request['end_date'];
            $obj['attachments']=$request['attachments'];

            if($request['id']>0){
                $tour=TourTravel::findOrFail($request['id']);
                $tour->update($obj);
            }else{
                $tour=TourTravel::create($obj);
            }

            return [
                'success' => true, 
                'message' => 'Saved Successfully',
                'data' => $tour
            ];
        }
    }

    public function tourTravelsList(Request $request){
        $validator=validator($request->all(),[
            'tour_package_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        }
        $tour=TourTravel::where('tour_package_id',$request['tour_package_id'])
            ->where('is_deleted',0)->get();
        return [
            'success' => true, 
            'data' => $tour,
            'message' => 'Tour Travel Lists'
        ];
    }

    public function tourTravelDetails(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $tour=TourTravel::findOrFail($request['id']);
            return [
                'success' => true, 
                'data' => $tour,
                'message' => 'Tour Travel Details'
            ];
        }
    }

    public function deleteTourTravel(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $tour=TourTravel::findOrFail($request['id']);
            $tour['is_deleted']=1;
            $tour->update();
            return [
                'success' => true, 
                'message' => 'Tour Travel Deleted Successfully'
            ];
        }
    }
}
