<?php

namespace App\Http\Controllers\Api\ProductServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Visa;
use Auth;

class VisaController extends Controller
{
    // create update visa
    public function visaCreateupdate(Request $request){
        
        $validator=validator($request->all(),[
            'visa_entry_type'=>'required',
            // 'country_id' => 'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $obj['visa_entry_type']=$request['visa_entry_type']??0;
            $obj['visa_entry_name']=$request['visa_entry_name'];
            $obj['country_id']=$request['country_id']??0;
            $obj['country_name']=$request['country_name'];
            $obj['visa_type_id']=$request['visa_type_id']??0;
            $obj['visa_type_name']=$request['visa_type_name'];
            $obj['days']=$request['days']??0;
            $obj['currency']=$request['currency'];
            $obj['currency_symbol']=$request['currency_symbol'];
            $obj['price']=$request['price']??0.0;
    
            if($request['id']>0){

                try {
                        
                    $visas=Visa::findOrFail($request['id']);

                    $visas->update($obj);
                //
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
                }
            }else{
                $visas=Visa::create($obj);
            }

            $response=[
                'success'=>true,
                'data'=>$visas,
                'message'=>$request['id']>0?'Visa Details Updated Successfully':"Visa Details Added Successfully",
            ];
    
            return response()->json($response);
        }
        
    }

    // get all visa lists
    public function getVisaList(Request $request){
        $user=Auth::user();

        $visas = Visa::where('is_disabled', 0);
        $visaEntryTypes=[];

        if($request['status']!=null && $request['status']!=0 && isset($request['status'])){
            $visas=$visas->where('status',$request['status']);
        }
        if($request['visa_entry_type']!=null && $request['visa_entry_type']!="" && isset($request['visa_entry_type'])){
            $visas=$visas->where('visa_entry_type',$request['visa_entry_type']);
        }
        if($request['country_id']!=null && $request['country_id']!="" && isset($request['country_id'])){
            $visas=$visas->where('country_id',$request['country_id']);

            $visaEntryTypes = Visa::where('is_disabled', 0)
                ->where('country_id',$request['country_id'])
                ->select('visa_entry_type')
                ->groupBy('visa_entry_type')
                ->get();
        }
        if($request['visa_type_id']!=null && $request['visa_type_id']!="" && isset($request['visa_type_id'])){
            $visas=$visas->where('visa_type_id',$request['visa_type_id']);
        }
        
        if($request['days']!=null && $request['days']!=0 && isset($request['days'])){
            $visas=$visas->where('days',$request['days']);
        }
        
        if ($request['search'] != null && $request['search'] != '') {

            $searchTerm = $request['search'];
            $visas = $visas->where(function ($query) use ($searchTerm) {
                $query->where('visa_entry_name', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('country_name', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('visa_type_name', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('price', 'LIKE', '%' . $searchTerm . '%')
                    ->orWhere('days', 'LIKE', '%' . $searchTerm . '%');
            });
        }
    
        $count=$visas->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $visas = $visas->orderby($request['sort_by'],$sort_order);

        }else{
            $visas = $visas->orderby('id','desc');
        }
        
        $visas=$visas->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();
        

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$visas,
            'visaEntryTypes'=>$visaEntryTypes,
            'message'=>'All Visa Listed Successfully'
        ];
        
        return response()->json($response);
    }

    // Visa Details
    public function visaDetails(Request $request){

        $validator=validator($request->all(),[
            'visa_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $visas=Visa::findOrFail($request['visa_id']);

            $response=[
                'success'=>true,
                'data'=>$visas,
                'message'=>'Visa Details Fetched Successfully'
            ];
            
            return response()->json($response);

        }
    }

    // Status
    public function changeVisaStatus(Request $request){
        
        $validator=validator($request->all(),[
            'visa_id'=>'required',
            'status'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $visas=Visa::findOrFail($request['visa_id']);
                $visas['status']=$request['status'];

                $visas->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to update '], 404);
            }

            $response=[
                'success'=>true,
                'data'=>$visas,
                'message'=>'Visa Status Updated Successfully',
            ];
    
            return response()->json($response);
        }
    }

    // Delete
    public function deleteVisa(Request $request){
        
        $validator=validator($request->all(),[
            'visa_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            try {
                    
                $visas=Visa::findOrFail($request['visa_id']);
                $visas['is_disabled']=1;

                $visas->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to Delete '], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'Visa Deleted Successfully',
            ];
    
            return response()->json($response);
        }
    }
}
