<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebitNote;
use App\Models\DebitNoteItem;
use App\Models\Vendor;
use App\Models\Transaction;
use App\Service\StockEntryService;
use App\Service\AccountsTransactionService;
use Illuminate\Support\Facades\Redirect;
use Auth;
use App\Service\StaticMaster;
use App\Models\Bill;

class DebitNoteController extends Controller
{
    public function list(Request $request)
    {
        $user=Auth::user();

        $validator=validator($request->all(),[
            'fy'=>'required',
            // 'warehouse_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $debitnotes= DebitNote::where('organisation_id',$user['active_organisation'])
                ->with('vendor','bill')
                // ->where('warehouse_id',$request['warehouse_id'])
                ->where('fy',$request['fy']);


                if ($request['status']!='' && isset($request['status'])) {

                    $debitnotes=$debitnotes->where('status',$request['status']);
    
                }
                if($request['search']!=null && $request['search']!=''){
    
                    // $searchTerm = $request['search'];
    
                    $debitnotes = $debitnotes->where(function ($query) use ($request) {
    
                        $query->where('debit_note_id', 'LIKE', '%' . $request['search'] . '%')
    
                            ->orWhere('reference_no', 'LIKE', '%' . $request['search'] . '%')
    
                            ->orWhere('display_name', 'LIKE', '%' . $request['search'] . '%')
    
                            ->orWhere('vendor_type', 'LIKE', '%' . $request['search'] . '%')
    
                            ->orWhere('total', 'LIKE', '%' . $request['search'] . '%')
    
                            ->orWhere('phone', 'LIKE', '%' . $request['search'] . '%')
    
                            ->orWhere('email', 'LIKE', '%' . $request['search'] . '%');
                    });
    
                }
    
                    // get alphabetically data by customer_name
    
                if ($request['customer_name']!='' && isset($request['customer_name'])) {
    
                    $debitnotes=$debitnotes->orderBy('customer_name');
    
                }
                    // get custom_date data by transaction_date
    
                if ($request['custom_date']!='' && isset($request['custom_date'])) {
    
                    $customDate = $request->custom_date;
    
                    $debitnotes = $debitnotes->whereDate('transaction_date', $customDate);
    
                }

                if ($request['vendor_id']!='' && $request['vendor_id']!=null && isset($request['vendor_id'])) {
                    $debitnotes=$debitnotes->where('vendor_id',$request['vendor_id']);
                }
    
                    // get fromDate toDate data by created_at
    
                if ($request['from_date']!='' && isset($request['to_date'])) {
    
                    $fromDate = $request->from_date;
    
                    $toDate = $request->to_date;
    
                    // 'fromDate' and 'toDate'
    
                    $debitnotes = $debitnotes->whereBetween('transaction_date', [$fromDate, $toDate]);
    
                }

                $count=$debitnotes->count();

            if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
                $sort_order=$request['sort_order']==1?'asc':'desc';

                $debitnotes = $debitnotes->orderby($request['sort_by'],$sort_order);

            }else{
                $debitnotes = $debitnotes->orderby('id','desc');
            }

            $debitnotes= $debitnotes->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                ->get();

            $response=[
                'message'=>'Debit Note List Fetched Successfully',

                'count'=>$count,

                'success'=>true,

                'debit_notes'=>$debitnotes,
            ];

            return response()->json($response);
        }
    }

    public function details(Request $request)
    {
         // Validate Item
        $user=Auth::user();

         $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $debitnotes = DebitNote::where('id',$request['id'])
                ->where('organisation_id',$user['active_organisation'])
                ->with('items','vendor','items.item','bill')
                ->first();

            $transaction=Transaction::where('transaction_type',StaticMaster::$DEBIT_NOTE)
                ->where('transaction_id',$request['id'])
                ->where('is_disabled',0)
                ->with('account:id,account_name,account_code')
                ->get();

            $response=[
                'message'=>' Debit Note Details fetched successfully',
                'debit_note'=>$debitnotes,
                'transaction'=>$transaction
            ];

            return response()->json($response);
        }

    }


    public function destroy(Request $request)
    {
        // Validate Item

        $validator=validator($request->all(),[

            'id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            try{

                $debitnotes = DebitNote::findOrFail($request['id']);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            if($debitnotes['is_approved']==0){

                $debitnotes->delete();

                $debitnote_items=DebitNoteItem::where('transaction_id',$debitnotes['id'])->get();
                
                foreach ($debitnote_items as $value){
                    $value->delete();
                }

                $response=[
                    'success'=>true,
                    'message'=>'Debit Note deleted Successfully'
                ];

            }else{

                $response=[
                    'success'=>false,
                    'message'=>'Debit Note is Approved. You can\'t delete this Debit Note.'
                ];

            }

            return response()->json($response);
        }
    }

    public function approveDebitNote(Request $request){

        $validator=Validator::make($request->all(),[
            'debit_note_id'=>'required'
        ]);

        $entity='DebitNote';

        if ($validator->fails()) {
            # code...
            
            $response=[ 
                'success'=>false,
                'message'=>$validator->errors()->first()
                
            ];
            return response()->json($response);    
        }

        else{
            $transaction = DebitNote::find($request->debit_note_id);
            $transaction['is_approved']=1;
            $transaction->update();  

            // Saving Accounts Entries
            $accountsEntryService = new AccountsTransactionService;
            $accountsEntryService->debitNote_accounts_transaction($transaction);

            // $stockEntryService = new StockEntryService;
            // $stockEntryService->saveStockEntries( $transaction,$entity,2);
        }
        $response=[ 
            'success'=>true,
            'message'=>'Debit Note Approved Successfully'
        ];

        return response()->json($response);
    }


    public function statusDebitNote(Request $request){
        // Validate Item
        $status_change='';

        $validator=validator($request->all(),[

            'id'=>'required',
            'status'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {
            $transaction = DebitNote::findOrFail($request->id);

            $bill = Bill::findOrFail($transaction['bill_id']);

            $transaction['status']=$request['status'];

            if($request['status']==1){

                $status_change='Approved';
                $transaction['is_approved']=1;

                $entity='DebitNote';

                // get balance Amount
                $balance_amount=$bill['total'] - $bill['amount_paid'];

                //check the invoice payment status and update the amount paid in invoice table
                if($balance_amount == $transaction['total']){

                    $bill['amount_paid']=$bill['amount_paid'] + $transaction['total'];
                    $bill->update();

                    //update credit note amount_paid
                    $transaction['amount_paid']= $transaction['amount_paid'] + $transaction['total'];
                    $transaction->update();
                    
                }else if($balance_amount < $transaction['total']){

                    $bill['amount_paid']=$bill['amount_paid'] + $balance_amount;
                    $bill->update();

                    //update credit note amount_paid
                    $transaction['amount_paid']=$balance_amount;
                    $transaction->update();

                }else{

                    $bill['amount_paid']=$bill['amount_paid'] + $transaction['total'];
                    $bill->update();

                    //update credit note amount_paid
                    $transaction['amount_paid']=$transaction['amount_paid'] + $transaction['total'];
                    $transaction->update();
                }


                // Saving Stock Entries
                $stockEntryService = new StockEntryService;
                $stockEntryService->saveStockEntries( $transaction,$entity,2);

                // Saving Accounts Entries
                $accountsEntryService = new AccountsTransactionService;
                $accountsEntryService->debitNote_accounts_transaction($transaction);

            }

            if($request['status']==2){

                $status_change='Declined';
                $transaction['is_approved']=0;

            }

            if($request['status']==0){

                $status_change='Draft';
            }

            $transaction->update();  

            $response=[ 

                'success'=>true,
    
                'message'=>'Debit Note '.$status_change.' Updated Successfully'
    
            ];

            return response()->json($response);

        }
    }
}
