<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Service\ActivityService;
use App\Service\StaticMaster;
use App\Service\StockEntryService;
use App\Models\GRN;
use App\Models\Item;
use App\Models\GRNItems;
use App\Models\GRNCharge;
use App\Service\GRNItemService;
use App\Service\GRNChargesService;
use Auth;

class GRNReceiptController extends Controller
{
    public function grnItemLists(Request $request){

        $user=Auth::user();

        $grn_items=GRNItems::where('is_approved',1)
            ->with('grn','item')
            // ->where('organisation_id',$user['active_organisation'])
            ->where('is_disabled',0)
            ->where('is_transfer',0);

        if($request['search']!=null && $request['search']!=''){

            // $searchTerm = $request['search'];

            $grn_items = $grn_items->where(function ($query) use ($request) {

                $query->where('gr_qty', $request['search'])

                    ->orWhereHas('item', function ($query) use ($request) {
                        $query->where('name', 'LIKE', '%' . $request['search'] . '%');
                    })

                    ->orWhereHas('grn', function ($query) use ($request) {
                        $query->where('grn_no', 'LIKE', '%' . $request['search'] . '%');
                    })

                    ->orWhereHas('grn', function ($query) use ($request) {
                        $query->where('transaction_date', 'LIKE', '%' . $request['search'] . '%');
                    });

                    // ->orWhere('display_name', 'LIKE', '%' . $request['search'] . '%')
            });

        }

        if ($request['from_date']!='' && isset($request['to_date'])) {

            // 'fromDate' and 'toDate'
            $grn_items = $grn_items->whereHas('grn', function ($query) use ($request) {
                $query->whereBetween('transaction_date', [$request['from_date'], $request['to_date']]);
            });

        }   

        $count=$grn_items->count();

        if(isset($request['sort_by']) && $request['sort_by'] != '' && $request['sort_by'] != null) {
    
            $sort_order = $request['sort_order'] == 1 ? 'asc' : 'desc';
            $sort_by = $request['sort_by'];
        
            // Sorting by 'transaction_date' from 'grn' relation
            if ($sort_by == 'transaction_date') {
                $grn_items = $grn_items->orderBy(
                    Grn::select('transaction_date')
                        ->whereColumn('g_r_n_s.id', 'g_r_n_items.transaction_id'), 
                    $sort_order
                );
            
            // Sorting by 'grn_no' from 'grn' relation
            } elseif ($sort_by == 'grn_no') {
                $grn_items = $grn_items->orderBy(
                    Grn::select('grn_no')
                        ->whereColumn('g_r_n_s.id', 'g_r_n_items.transaction_id'), 
                    $sort_order
                );
            
            // Sorting by 'item_name' from 'item' relation
            } elseif ($sort_by == 'item_name') {
                $grn_items = $grn_items->orderBy(
                    Item::select('name')
                        ->whereColumn('items.id', 'g_r_n_items.item_id'), 
                    $sort_order
                );
            
            } else {
                // Sort by columns from grn_items table
                $grn_items = $grn_items->orderBy($sort_by, $sort_order);
            }
        
        } else {
            // Default sorting if no 'sort_by' is provided
            $grn_items = $grn_items->orderBy('id', 'desc');
        }
          
    
        $grn_items=$grn_items->skip($request['noofrec']*($request['currentpage']-1))
            ->take($request['noofrec']??100)
            ->get();

        $response=[
            'message'=>'GRN Items List Fetched Successfully',
            'success'=>true,
            'count'=>$count,
            'grn_items'=>$grn_items
        ];

        return response()->json($response);

    }

    public function details(Request $request){
        $user=Auth::user();

        $validator=validator($request->all(),[

            'id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            $grn_items=GRNItems::with('grn','item','grn.vendor','grn.purchase_order')
                ->where('organisation_id',$user['active_organisation'])
                ->where('is_transfer',0)
                ->find($request['id']);

            if($grn_items!=null){

                $response=[
                    'message'=>'GRN Item Details Fetched Successfully',
                    'success'=>true,
                    'grn_items'=>$grn_items
                ];

            }else{

                $response=[
                    'message'=>'GRN Item Details Not found ',
                    'success'=>false,
                    'grn_items'=>$grn_items
                ];
            }

            return response()->json($response);
        }
    }

    public function moveItems(Request $request){
        $user=Auth::user();

        $validator=validator($request->all(),[

            'id'=>'required',

        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $grn_items=GRNItems::where('id',$request['id'])->first();

            $stockservice=new StockEntryService;

            $stockservice->addGrnReceiptStock($grn_items,$request);

            $grn_items['is_transfer']=1;
            $grn_items->update();

            $response=[
                'message'=>'GRN Item Moved Successfully',
                'success'=>true,
            ];

            return response()->json($response);
        }
    }
}
