<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Http\Controllers\Controller;
use App\Models\PaymentMade;
use App\Models\Vendors;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class PaymentMadeController extends Controller
{
    public function list(Request $request)
    {
        $paymentMade= PaymentMade::all();

        return response()->json($paymentMade);
    }

    public function details(Request $request)
    {

        $paymentMade = PaymentMade::findOrFail($id);

        $response=[
            'PaymentMade'=>$paymentMade,
            'items'=>$items,
        ];

        return response()->json($response);

    }

   
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            // Add more validation rules as needed
        ]);
        $paymentMade = new PaymentMade;
        $paymentMade->name = $validatedData['name'];
        $paymentMade->save();

        $response=[
            'PaymentMade'=>$paymentMade,
            'success'=>true,
            'message'=>'PaymentMade Created Successfully'
        ];

        return response()->json($response);
    }

    public function destroy($id)
    {
        $paymentMade = PaymentMade::findOrFail($id);
        $paymentMade->delete();

        $response=[
            'success'=>true,
            'message'=>'PaymentMade deleted Successfully'
        ];

        return response()->json($response);
    }

}