<?php



namespace App\Http\Controllers\Api\Purchase;



use App\Http\Controllers\Controller;

use App\Models\PurchaseOrder;

use App\Models\PurchaseOrderItem;

use App\Models\User;

use App\Models\Vendors;

use Illuminate\Http\Request;

use App\Models\SentMail;

use Illuminate\Support\Facades\Http;

use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Facades\Redirect;

use Auth;



class PurchaseOrderController extends Controller

{

    public function list(Request $request)

    {

        $user=Auth::user();

         // Validate Item

         $validator=validator($request->all(),[

            'fy'=>'required',
            // 'warehouse_id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {


            if($user!=null){

                $purchaseOrder= PurchaseOrder::where('organisation_id',$user['active_organisation'])

                    ->where('fy',$request['fy'])
                    // ->where('warehouse_id',$request['warehouse_id'])

                    ->with('items','vendor');

                if($request['search']!=null && $request['search']!=''){

                    $purchaseOrder = $purchaseOrder->where(function ($query) use ($request) {
                        
                        $query->where('purchase_order_id', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('display_name', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('vendor_type', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('phone', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('email', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('reference_no', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('reference', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('reference', 'LIKE', '%' . $request['search'] . '%')

                            ->orWhere('total', 'LIKE', '%' . $request['search'] . '%');
                    });

                }

                if ($request['vendor_id']!=0 && $request['vendor_id']!='' && isset($request['vendor_id'])) {
    
                    $purchaseOrder = $purchaseOrder->where('vendor_id',$request['vendor_id']);
    
                }
                if (isset($request['status'])) {
    
                    $purchaseOrder = $purchaseOrder->where('status',$request['status']);
    
                }

                if ($request['custom_date']!='' && isset($request['custom_date'])) {

                    $customDate = $request->custom_date;
    
                    $purchaseOrder = $purchaseOrder->whereDate('transaction_date', $customDate);
    
                }

                if ($request['from_date']!='' && isset($request['to_date'])) {

                    $fromDate = $request->from_date;
    
                    $toDate = $request->to_date;
    
                    // 'fromDate' and 'toDate'
    
                    $purchaseOrder = $purchaseOrder->whereBetween('transaction_date', [$fromDate, $toDate]);
    
                }

                $purchaseOrder_count=$purchaseOrder->count();

                if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
                    $sort_order=$request['sort_order']==1?'asc':'desc';
    
                    $purchaseOrder = $purchaseOrder->orderby($request['sort_by'],$sort_order);
    
                }else{
                    $purchaseOrder = $purchaseOrder->orderby('id','desc');
                }

                $purchaseOrder=$purchaseOrder->skip($request['noofrec']*($request['currentpage']-1))
                                ->take($request['noofrec']??100)
                                ->get();

                $response=[

                    'success'=>true,

                    'message'=>'Purchase Order fetched Successfully',

                    'total'=>$purchaseOrder_count,

                    'purchase_order'=>$purchaseOrder

                ];


            } else {

                $response=[

                    'success'=>false,

                    'message'=>'Your Are not Authenticated',

                    'total'=>null,

                    'item'=>null

                ];

            }

        }

        return response()->json($response);

    }


    public function details(Request $request)
    {
        // Validate Item
        $user=Auth::user();

        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            $purchaseOrder = PurchaseOrder::where('id',$request['id'])

                ->where('organisation_id',$user['active_organisation'])

                ->with('items','vendor','items.item','activity')

                ->first();

            if ($purchaseOrder['items']->count() > 0) {
                foreach ($purchaseOrder['items'] as $key => $item) {
                    if (!empty($item->service_data)) {
                        $service_data = $item->service_data; // already array

                        // Getting Guests 
                        $guestIds = explode(',', $service_data['guest_ids'] ?? '');
                        $service_data['guests'] = User::whereIn('id', $guestIds)->get();

                        // Laravel will auto re-encode to JSON when saving
                        $item->service_data = $service_data;
                        $item->save();
                    }
                }
            }

            $response=[
                'purchaseOrder'=>$purchaseOrder,
                'success'=>true,
                'message'=>'Details Fetch Successfully',
            ];

            return response()->json($response);

        }

    }



    public function send_mail(Request $request)
    {
        // Validate Item

        $validator=validator($request->all(),[

            'id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 
                'message' => $validator->errors()->first()

            ];

        } else {

            try{

                $purchase_order = PurchaseOrder::where('id',$request['id'])

                    ->with('items','items.item','vendor')->first();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id to update '], 404);

            }

            // Send the email
            $email='';

           // if(isset($request['email']) && $request['email']!=null){

            //     $email=$request['email'];

            // }else if($sale_order!=null){

            //     $email=$sale_order['email'];
                
            // }else{
                $email=$request['to_email'];
            // }
            
            if($email!=null && $email!=''){

                $obj['to_email']=$request['to_email'];
                $obj['subject']=$request['subject'];
                $obj['body']=$request['body'];
                $obj['attachments']=$request['upload_documents'];
                $obj['module_id']=$request['id'];
                $obj['module_type']='purchase_order';

                $sent_email=SentMail::create($obj);

                $data['email']=$request['to_email'];

                $data['title']='Purchase order Details';

                $data['purchase_order']=$purchase_order;

                $data['mail_data']=$sent_email;

                // Define the file path to the attachment(s)
                $attachments =json_decode($request['upload_documents'], true);

                Mail::send('purchase-order.purchase-order', ['data' => $data], function ($message) use ($data, $attachments,$request) {
                    $message->to($data['email'])
                            ->subject($request['subject']);
                    
                     // Log::info($attachments);
 
                    foreach ($attachments as $attach) {

                        foreach ($attach as $url){

                            // Fetch the file content using Laravel HTTP client
                            $response = Http::get($url);
                            
                            if ($response->successful()) {
                                $fileContent = $response->body();
                                $contentType = $response->header('Content-Type');
                                
                                // Attach the file content to the email
                                $message->attachData($fileContent, "Attachment_name.pdf", [
                                    'mime' => $contentType,
                                ]);
                            }
                        }   
                    }
                });
 
                $response=[

                    'success'=>true,

                    'message'=>'Purchase Order sent Successfully'

                ];
 
            } else {

                $response=[

                    'success'=>false,

                    'message'=>'Customer Email Does not Exists'

                ];
            }
            return response()->json($response);

        }

    }

    public function destroy(Request $request)
    {
        // Validate Item

        $validator=validator($request->all(),[

            'id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            try{

                $purchase_order = PurchaseOrder::findOrFail($request['id']);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id to update '], 404);

            }

            if($purchase_order['is_approved']==0){

                $purchase_order->delete();

                $purchase_order_items=PurchaseOrderItem::where('transaction_id',$purchase_order['id'])->get();

                foreach ($purchase_order_items as $value){

                    $value->delete();

                }

                $response=[

                    'success'=>true,

                    'message'=>'Purchase Order deleted Successfully'

                ];

            }else{

                $response=[

                    'success'=>false,

                    'message'=>'Purchase Order is Approved. You can\'t delete this Purchase order.'

                ];

            }

            return response()->json($response);
        }

    }





    public function approvePurchaseOrder(Request $request){

        $validator=Validator::make($request->all(),[

            'id'=>'required'

        ]);

        if ($validator->fails()) {

            # code...
            $response=[ 

                'success'=>false,

                'message'=>$validator->errors()->first() 

            ];

            return response()->json($response);    

        }

        else{

            try{

                $transaction = PurchaseOrder::findOrFail($request->invoice_id);

                $transaction['is_approved']=1;
                $transaction['status']=1;

                $transaction->update();  

                // $stockEntryService = new StockEntryService;

                // $stockEntryService->saveStockEntries( $transaction,$entity,2);


            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id to update '], 404);

            }

        }

        $response=[ 

            'success'=>true,

            'message'=>'Purchase Order Approved Successfully'

        ];



        return response()->json($response);

    }


    public function statusPurchaseOrder(Request $request){
        // Validate Item
        $status_change='';

        $validator=validator($request->all(),[

            'id'=>'required',
            'status'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {
            $transaction = PurchaseOrder::findOrFail($request->id);

            $transaction['status']=$request['status'];

            if($request['status']==1){
                $status_change='Approved';
                $transaction['is_approved']=1;
            }
            if($request['status']==2){
                $status_change='Declined';
                $transaction['is_approved']=0;
            }
            if($request['status']==0){
                $status_change='Draft';
            }

            $transaction->update();  

            $response=[ 

                'success'=>true,
    
                'message'=>'Purchase Order '.$status_change.' Updated Successfully'
    
            ];

            return response()->json($response);

        }
    }
}