<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Http\Controllers\Controller;
use App\Models\VendorCredit;
use App\Models\Vendors;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class VendorCreditController extends Controller
{
    public function list(Request $request)
    {
        $vendorCredit= VendorCredit::all();

        return response()->json($vendorCredit);
    }

    public function details(Request $request)
    {

        $vendorCredit = VendorCredit::findOrFail($id);

        $response=[
            'VendorCredit'=>$vendorCredit,
            'items'=>$items,
        ];

        return response()->json($response);

    }

   
    public function store(Request $request)
    {
        // $validatedData = $request->validate([
        //     'name' => 'required|string|max:255',
        //     // Add more validation rules as needed
        // ]);

        $vendorCredit = new VendorCredit;
        // $vendorCredit->name = $validatedData['name'];
        $vendorCredit->customer_type = $request->input("customer_type");
        $vendorCredit->customer_id = $customer_id;
        $vendorCredit->customer_name = $customer_name;
        $vendorCredit->package = $request->input("package");
        $vendorCredit->VendorCredit_id = $dsr_number;
        $vendorCredit->currency = $request->input("currency");
        $vendorCredit->VendorCredit_date = $request->input("VendorCredit_date");
        $vendorCredit->expiry_date = $request->input("expiry_date");
        $vendorCredit->reference_no = $request->input("reference_no");
        $vendorCredit->customer_note = $request->input("customer_note");
        $vendorCredit->terms = $request->input("terms");
        $vendorCredit->subtotal = $request->input("subtotal");
        $vendorCredit->shipping_charge = $request->input("shipping_charge");
        $vendorCredit->adjustment_charge = $request->input("adjustment_charge");
        $vendorCredit->total = $request->input("VendorCredit_total");
        $vendorCredit->tax_type = $request->input("tax_type");

        if ($request->file('VendorCredit_file')) {
            $photo = $request->file('VendorCredit_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $vendorCredit->file = $filename;
        }

        $vendorCredit->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            $Items = new Items();
            $Items->VendorCredit_id = $dsr_number;
            $Items->item_details = $request->input("item_details")[$key];
            $Items->quantity = $request->input("quantity")[$key];
            $Items->rate = $request->input("rate")[$key];
            $Items->discount = $request->input("discount")[$key];
            $Items->tax_rate = $request->input("tax_rate")[$key];
            $Items->tax_amount = $request->input("tax_amount")[$key];
            $Items->total = $request->input("total")[$key];

            // $Items->rate = $request->input("rate");
            $Items->save();
        } 

        $response=[
            'VendorCredit'=>$vendorCredit,
            'success'=>true,
            'message'=>'VendorCredit Created Successfully'
        ];

        return response()->json($response);
    }

   
    public function update(Request $request)
    {
        
    }

    public function destroy($id)
    {
        $vendorCredit = VendorCredit::findOrFail($id);
        $vendorCredit->delete();

        $response=[
            'success'=>true,
            'message'=>'VendorCredit deleted Successfully'
        ];

        return response()->json($response);
    }

}