<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PurchaseOrder;
use App\Models\Bill;
use App\Models\PurchaseOrderItem;
use App\Models\BillItem;
use App\Service\PurchaseItemService;
use App\Service\UploadService;
use App\Service\CurrencyConvertService;
use App\Service\ActivityService;
use App\Service\StaticMaster;
use App\Service\SequenceService;
use App\Models\DsrSupplierSummary;

class PurchaseTransactionController extends Controller
{
    // Creating a new sale 
    public function createUpdateSale(Request $request){
        $validator=validator($request->all(),[
            'purchase_type'=>'required|string',
            // 'warehouse_id'=>'required',
            'fy'=>'required',
            'total'=>'required',
            'transaction_date'=>'required',
            'vendor_id'=>'required',
            // 'place_of_supply_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $data=[
                'purchase_from',
                'transaction_date',
                'expiry_date',
                'vendor_id',
                'fy',
                'warehouse_id',
                'vendor_type',
                'vendor_name',
                'display_name',
                'phone',
                'email',
                'address',
                'delivery_address',
                'currency',
                'currency_symbol',
                'terms_and_condition',
                'vendor_note',
                'tracking_details',
                'subtotal',
                'total',
                'discount',
                'tcs',
                'shipping_charge',
                'adjustment_charge',
                'reference_no',
                'reference',
                'place_of_supply',
                'sale_person',
                'upload_image',
                'shipment_date',
                'payment_terms',
                'date',
                'expected_delivery_Date',
                'shipment_preference',
                'customer_note',
                'status',
                'order_no',
                'amt_excess',
                'is_grn_convert',
                'grn_id',
                'charges',
                'exchange_rate',
                'is_gst_input',       //0 no input for gst (ITC), 1 input for gst (ITC)
                'input_tax',          // 1 eligible , 2 non-eligible
                'is_rcm',              // 1 eligible , 2 non-eligible
                'state_id'
            ];
            
            
            foreach ($data as $key => $value) {
                if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                    $obj[$value]=$request[$value];
                }

                if($request[$value]==''){
                    $obj[$value]=null;
                }

                if($request[$value]==0){
                    $obj[$value]=0;
                }
            }

            // Serivces to upload and sale items record
            $uploadService=new UploadService;
            $purchase_items=new PurchaseItemService;
            $currency_convert=new CurrencyConvertService;
            $sequence=new SequenceService;

            $transaction=[];
            $module='';

            // Purchase Orders 
            if($request['purchase_type']=='purchase_order'){

                $entity='PurchaseOrder';
                $module='purchase_order';

                if($request['id']>0){

                    try{
                        //Check if id is already exists
                        $transaction=PurchaseOrder::findOrFail($request['id']);
                        $obj['purchase_order_id']=$request['purchase_order_id'];
                        $transaction->update($obj);

                        // Creating Activities
                        $activity=new ActivityService;
                        $activity->activityCreateUpdate('Purchase Order',$transaction['id'],'Updated');

                        // Deleting all the records in items table
                        $item=PurchaseOrderItem::where('transaction_id',$request['id'])->delete();

                        // Creating items
                        $purchase_items->saveItems($request,$transaction);

                    } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                        // Return error message in JSON if ID not found
                        return response()->json(['message' => 'Invalid Id to update '], 404);
                    }


                }else{
                    $transaction=PurchaseOrder::create($obj);

                    $transaction['purchase_order_id']=$request['purchase_order_id'];
                    // $transaction['exchange_rate']=$currency_convert->getlatestCurrency($request['currency']);
                    $transaction['file']= $uploadService->uploadfile($request);
                    $transaction->update();

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Purchase Order',$transaction['id'],'Created');

                    // Creating items
                    $purchase_items->saveItems($request,$transaction);

                    // Update Sequence Number
                    $sequence->updateSequence($module);
                }     
            }

            // Bills
            if($request['purchase_type']=='bills'){

                $entity='Bill';
                $module='bill';

                if($request['id']>0){
                    try{
                        // Check if id exists then update
                        $transaction=Bill::findOrFail($request['id']);
                        $transaction['transaction_type']=StaticMaster::$PURCAHSE_TRANSACTION_TYPE;
                        $obj['bill_no']=$request['bill_no'];
                        $obj['charges']=$request['charges'];
                        $transaction->update($obj);

                        // Creating Activities
                        $activity=new ActivityService;
                        $activity->activityCreateUpdate('Bill',$transaction['id'],'Updated');

                        $bill_items=BillItem::where('transaction_id',$request['id'])->delete();

                        // Creating items
                        $purchase_items->saveItems($request,$transaction);

                    } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                        // Return error message in JSON if ID not found
                        return response()->json(['message' => 'Invalid Id to update '], 404);
                    }


                }else{

                    // for naksha 
                    // if(isset($request['supplier_summary_ids']) && $request['supplier_summary_ids']!=null){
                    //     foreach ($request['supplier_summary_ids'] as $key => $value) {
                    //         DsrSupplierSummary::where('id',$value)->update(['is_billed'=>1]);
                    //     }
                    // }

                    $transaction=Bill::create($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Bill',$transaction['id'],'Created');

                    $transaction['bill_no']=$request['bill_no'];
                    $transaction['transaction_type']=StaticMaster::$PURCAHSE_TRANSACTION_TYPE;

                    // Naksha 
                    if(isset($request['supplier_summary_ids']) && $request['supplier_summary_ids']!=null){
                        $transaction['supplier_summary_ids']=$request['supplier_summary_ids'];
                        $transaction['is_dsr']=$request['is_dsr']??0;
                        $transaction['is_mice']=$request['is_mice']??0;
                        $transaction['is_service']=$request['is_service']??0;
                    }
                    
                    $transaction['file']= $uploadService->uploadfile($request); //service to call an upload  file method from the UploadService class.
                    $transaction->update();

                    // Creating items
                    $purchase_items->saveItems($request,$transaction);

                    // Update Sequence Number
                    $sequence->updateSequence($module);
                }
            }

            return response()->json(['status'=>200,'message'=>'Transaction Created Successfully','transaction'=>$transaction],200);
        }

    }
}
