<?php

namespace App\Http\Controllers\Api\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebitNote;
use Carbon\Carbon;

class DebitNoteReportController extends Controller
{
    public function debit_note_report(Request $request){

        $endDate = $request->input('end_date') ?: Carbon::today()->format('Y-m-d');
        $startDate = $request->input('start_date') ?: Carbon::today()->startOfMonth()->format('Y-m-d') ;

        $debitnotes= DebitNote::with('vendor','bill')
            // ->where('organisation_id',$user['active_organisation'])
            // ->where('warehouse_id',$request['warehouse_id'])
            ->where('fy',$request['fy'])
            ->whereBetween('transaction_date', [$startDate, $endDate])
            ->orderBy('transaction_date')
            ->get();

            
        $response=[
            'success' => true,
            'message' => 'Debit Notes Detail Report',
            'startDate'=>$startDate,
            'endDate'=>$endDate,
            'data' => $debitnotes
        ];

        // Return a view or JSON response
        return response()->json($response);

    }
}
