<?php

namespace App\Http\Controllers\Api\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class PurchaseReportController extends Controller
{
    public function getVendorPurchaseReport(Request $request)
    {
        // Get the date range from the request, or set default to the last 1 month
        $endDate = $request->input('end_date') ?: Carbon::today()->format('Y-m-d');
        $startDate = $request->input('start_date') ?: Carbon::today()->startOfMonth()->format('Y-m-d') ;

        // Query the database
        $report = DB::table('bills')

            // ->join('users', 'invoices.customer_id', '=', 'users.id') // Join the customer table
            ->where('bills.is_approved', 1)
            ->select(
                'vendor_id','display_name',
                // DB::raw('COUNT(*) as number_of_purchases'),
                // DB::raw('ROUND(SUM(subtotal), 2) as total_purchase_amount'),
                // DB::raw('ROUND(SUM(total), 2) as total_amount')
                DB::raw('COUNT(CASE WHEN is_approved = 1 THEN 1 END) as number_of_purchases'), 
                DB::raw('ROUND(SUM(CASE WHEN is_approved = 1 THEN subtotal ELSE 0 END), 2) as total_purchase_amount'),
                DB::raw('ROUND(SUM(CASE WHEN is_approved = 1 THEN total ELSE 0 END), 2) as total_amount')
            )
            ->whereBetween('transaction_date', [$startDate, $endDate])
            ->groupBy('vendor_id','display_name')
            ->orderBy('total_amount', 'DESC')
            ->get();

        // Return the report as JSON or a view
        $response=[
            "success"=>true,
            "message"=>"Vendor Purchase Report Generate Successfully",
            "start_date"=>$startDate,
            "end_date"=>$endDate,
            "data"=>$report
        ];

        return response()->json($response);
    }
}
