<?php

namespace App\Http\Controllers\Api\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Service\AccountsTransactionService;
use Carbon\Carbon;
use Log;

class ReceivableReportController extends Controller
{
    public function get_all_customer_summary(Request $request){

        $endDate = $request->input('end_date') ?: Carbon::today()->format('Y-m-d');
        $startDate = $request->input('start_date') ?: Carbon::today()->startOfMonth()->format('Y-m-d') ;
        
        //Object to get accounts details
        $transaction_accounts=new AccountsTransactionService;
        $receivables=$transaction_accounts->get_accounts('accounts_receivable');

        // Assuming $receivables contains the required account ID
        $customers = User::whereHas('cust_transactions', function ($query) use ($receivables, $startDate, $endDate) {
                $query->where('account_id', $receivables['id'])
                    ->whereBetween('transaction_date', [$startDate, $endDate]);
            })
            ->with(['cust_transactions' => function ($query) use ($receivables, $startDate, $endDate) {
                $query->where('account_id', $receivables['id'])
                    ->select(
                        'customer_id',
                        DB::raw('SUM(CASE WHEN transaction_date BETWEEN ? AND ? THEN debit ELSE 0 END) as total_debit'),
                        DB::raw('SUM(CASE WHEN transaction_date BETWEEN ? AND ? THEN credit ELSE 0 END) as total_credit')
                    )
                    ->addBinding([$startDate, $endDate, $startDate, $endDate], 'select')
                    ->groupBy('customer_id');
            }])
            ->where('is_customer',1)
            ->where('status', 1)
            ->select('id', 'display_name', 'balance')
            ->orderBy('display_name')
            ->get();

        // Calculate Total Receivables (Sum of Total Debit - Total Credit)
        $totalReceivables = $customers->sum(function ($customer) {
            $totalDebit = $customer->cust_transactions->sum('total_debit');
            $totalCredit = $customer->cust_transactions->sum('total_credit');
            return $totalDebit - $totalCredit; // Net receivable per customer
        });


        $response=[
            'success' => true,
            'message' => 'Customers Summary Report Generated successfully',
            'total_receivables' => $totalReceivables,
            'startDate'=>$startDate,
            'endDate'=>$endDate,
            'account_name'=>$receivables['account_name'],
            'account_id'=>$receivables['id'],
            'data' => $customers
        ];

        // Return a view or JSON response
        return response()->json($response);
    }
}
