<?php
namespace App\Http\Controllers\Api\Sales;
use App\Http\Controllers\Controller;

use App\Models\PaymentReceived;
use App\Models\Customers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class PaymentReceivedController extends Controller
{
    public function list(Request $request)
    {
        $paymentReceived= PaymentReceived::all();

        return response()->json($paymentReceived);
    }

    public function details(Request $request)
    {

        $paymentReceived = PaymentReceived::findOrFail($id);

        $response=[
            'PaymentReceived'=>$paymentReceived,
            'items'=>$items,
        ];

        return response()->json($response);

    }

   
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            // Add more validation rules as needed
        ]);
        $paymentReceived = new PaymentReceived;
        $paymentReceived->name = $validatedData['name'];
        $paymentReceived->save();

        $response=[
            'PaymentReceived'=>$paymentReceived,
            'success'=>true,
            'message'=>'PaymentReceived Created Successfully'
        ];

        return response()->json($response);
    }

   
    public function update(Request $request)
    {
        
    }

    public function destroy($id)
    {
        $paymentReceived = PaymentReceived::findOrFail($id);
        $paymentReceived->delete();

        $response=[
            'success'=>true,
            'message'=>'PaymentReceived deleted Successfully'
        ];

        return response()->json($response);
    }

}